/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.processor;

import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.jca.composer.JCAComposition;
import org.switchyard.component.jca.processor.AbstractOutboundProcessor;
import org.switchyard.exception.SwitchYardException;

public class JMSProcessor
extends AbstractOutboundProcessor {
    public static final String KEY_USERNAME = "userName";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_TRANSACTED = "transacted";
    public static final String KEY_ACKNOWLEDGE_MODE = "acknowledgeMode";
    public static final String KEY_DESTINATION = "destination";
    private String _userName;
    private String _password;
    private String _transacted;
    private boolean _txEnabled;
    private String _destination;
    private String _acknowledgeMode;
    private int _ackMode;
    private ConnectionFactory _connectionFactory;
    private Destination _jmsDestination;

    @Override
    public AbstractOutboundProcessor setConnectionSpec(String name, Properties props) {
        return this;
    }

    @Override
    public AbstractOutboundProcessor setInteractionSpec(String name, Properties props) {
        return this;
    }

    @Override
    public void initialize() {
        this._txEnabled = this._transacted == null || this._transacted.equals("") ? true : Boolean.parseBoolean(this._transacted);
        this._ackMode = this._acknowledgeMode == null || this._acknowledgeMode.equals("") ? 0 : Integer.parseInt(this._acknowledgeMode);
        if (this._destination == null) {
            throw new SwitchYardException("destination property must be specified in Processor properties");
        }
        try {
            InitialContext ic = new InitialContext();
            this._connectionFactory = (ConnectionFactory)ic.lookup(this.getConnectionFactoryJNDIName());
            this._jmsDestination = (Destination)ic.lookup(this._destination);
        }
        catch (Exception e) {
            throw new SwitchYardException("Failed to initialize " + this.getClass().getName(), (Throwable)e);
        }
    }

    @Override
    public void uninitialize() {
        this._destination = null;
        this._connectionFactory = null;
    }

    @Override
    public Message process(Exchange exchange) throws HandlerException {
        Connection connection = null;
        Session session = null;
        try {
            connection = this._userName != null ? this._connectionFactory.createConnection(this._userName, this._password) : this._connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(this._txEnabled, this._ackMode);
            BytesMessage msg = session.createBytesMessage();
            MessageProducer producer = session.createProducer(this._jmsDestination);
            MessageComposer<javax.jms.Message> composer = JCAComposition.getMessageComposer(javax.jms.Message.class);
            producer.send((javax.jms.Message)composer.decompose(exchange, (Object)msg));
            Message message = null;
            return message;
        }
        catch (Exception e) {
            throw new HandlerException("Failed to process JMS outbound interaction", (Throwable)e);
        }
        finally {
            try {
                session.close();
                connection.close();
            }
            catch (JMSException e) {
                e.getMessage();
            }
        }
    }

    public void setDestination(String name) {
        this._destination = name;
    }

    public void setUsername(String user) {
        this._userName = user;
    }

    public void setPassword(String passwd) {
        this._password = passwd;
    }

    public void setTransacted(String tx) {
        this._transacted = tx;
    }

    public void setAcknowledgeMode(String ack) {
        this._acknowledgeMode = ack;
    }
}

