/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.jca.composer.JMSBindingData;

public class JMSContextMapper
extends BaseRegexContextMapper<JMSBindingData> {
    public void mapFrom(JMSBindingData source, Context context) throws Exception {
        Message message = source.getMessage();
        Enumeration e = message.getPropertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (!this.matches(key)) continue;
            Object value = null;
            try {
                value = message.getObjectProperty(key);
            }
            catch (JMSException pce) {
                pce.getMessage();
            }
            if (value == null) continue;
            context.setProperty(key, value, Scope.EXCHANGE).addLabels(new String[]{"jca_message_property"});
        }
    }

    public void mapTo(Context context, JMSBindingData target) throws Exception {
        Message message = target.getMessage();
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            Object value;
            String name = property.getName();
            if (!this.matches(name) || (value = property.getValue()) == null) continue;
            try {
                message.setObjectProperty(name, value);
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
    }
}

