/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.jca.composer.JMSBindingData;
import org.switchyard.exception.SwitchYardException;

public class JMSMessageComposer
extends BaseMessageComposer<JMSBindingData> {
    public Message compose(JMSBindingData source, Exchange exchange, boolean create) throws Exception {
        Message syMessage = create ? exchange.createMessage() : exchange.getMessage();
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext());
        javax.jms.Message jmsMessage = source.getMessage();
        if (jmsMessage instanceof BytesMessage) {
            BytesMessage sourceBytes = (BytesMessage)BytesMessage.class.cast(jmsMessage);
            if (sourceBytes.getBodyLength() > Integer.MAX_VALUE) {
                throw new SwitchYardException("The size of message content exceeds 2147483647 bytes, that is not supported by this MessageComposer");
            }
            byte[] bytearr = new byte[(int)sourceBytes.getBodyLength()];
            sourceBytes.readBytes(bytearr);
            syMessage.setContent((Object)bytearr);
        } else if (jmsMessage instanceof MapMessage) {
            MapMessage sourceMap = (MapMessage)MapMessage.class.cast(jmsMessage);
            HashMap<String, Object> body = new HashMap<String, Object>();
            Enumeration e = sourceMap.getMapNames();
            while (e.hasMoreElements()) {
                String key = (String)String.class.cast(e.nextElement());
                body.put(key, sourceMap.getObject(key));
            }
            syMessage.setContent(body);
        } else if (jmsMessage instanceof ObjectMessage) {
            ObjectMessage sourceObj = (ObjectMessage)ObjectMessage.class.cast(jmsMessage);
            syMessage.setContent((Object)sourceObj.getObject());
        } else if (jmsMessage instanceof StreamMessage) {
            StreamMessage sourceStream = (StreamMessage)StreamMessage.class.cast(jmsMessage);
            syMessage.setContent((Object)sourceStream);
        } else if (jmsMessage instanceof TextMessage) {
            TextMessage sourceText = (TextMessage)TextMessage.class.cast(jmsMessage);
            syMessage.setContent((Object)sourceText.getText());
        } else {
            syMessage.setContent(null);
        }
        return syMessage;
    }

    public JMSBindingData decompose(Exchange exchange, JMSBindingData target) throws Exception {
        this.getContextMapper().mapTo(exchange.getContext(), (BindingData)target);
        javax.jms.Message jmsMessage = target.getMessage();
        ObjectMessage targetObj = (ObjectMessage)ObjectMessage.class.cast(jmsMessage);
        targetObj.setObject((Serializable)exchange.getMessage().getContent(Serializable.class));
        return target;
    }
}

