/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import javax.resource.cci.MappedRecord;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.jca.composer.MappedRecordBindingData;

public class MappedRecordContextMapper
extends BaseRegexContextMapper<MappedRecordBindingData> {
    public void mapFrom(MappedRecordBindingData source, Context context) throws Exception {
        String recordDescription;
        MappedRecord record = source.getRecord();
        String recordName = record.getRecordName();
        if (recordName != null) {
            context.setProperty("recordName", (Object)recordName, Scope.EXCHANGE).addLabels(new String[]{"jca_message_property"});
        }
        if ((recordDescription = record.getRecordShortDescription()) != null) {
            context.setProperty("recordShortDescription", (Object)recordDescription, Scope.EXCHANGE).addLabels(new String[]{"jca_message_property"});
        }
    }

    public void mapTo(Context context, MappedRecordBindingData target) throws Exception {
        MappedRecord record = target.getRecord();
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null) continue;
            if (name.equals("recordName")) {
                record.setRecordName(value.toString());
                continue;
            }
            if (name.equals("recordShortDescription")) {
                record.setRecordShortDescription(value.toString());
                continue;
            }
            if (!this.matches(name)) continue;
            record.put((Object)name, value);
        }
    }
}

