/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.switchyard.component.jca.config.model.v1;

import org.switchyard.component.common.selector.config.model.v1.V1CommonBindingMarshaller;
import org.switchyard.component.jca.JCAConstants;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composer.ContextMapperModel;
import org.switchyard.config.model.composer.MessageComposerModel;
import org.switchyard.config.model.composer.v1.V1ContextMapperModel;
import org.switchyard.config.model.composer.v1.V1MessageComposerModel;

/**
 * V1 model marshaller for jca binding.
 * 
 * @author <a href="mailto:tm.igarashi@gmail.com">Tomohisa Igarashi</a>
 *
 */
public class V1JCAModelMarshaller extends V1CommonBindingMarshaller {

    /**
     * Constructor.
     * 
     * @param desc The descriptor for this model.
     */
    public V1JCAModelMarshaller(Descriptor desc) {
        super(desc);
    }

    @Override
    public Model read(final Configuration config) {
        final String name = config.getName();
        
        if (name.equals(JCAConstants.BINDING + "." + JCAConstants.JCA)) {
           return new V1JCABindingModel(config, getDescriptor());
        }
        if (name.equals(ContextMapperModel.CONTEXT_MAPPER)) {
            return new V1ContextMapperModel(config, getDescriptor());
        }
        if (name.equals(MessageComposerModel.MESSAGE_COMPOSER)) {
            return new V1MessageComposerModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.OUTBOUND_CONNECTION)) {
            return new V1OutboundConnectionModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.INBOUND_CONNECTION)) {
            return new V1InboundConnectionModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.OUTBOUND_INTERACTION)) {
            return new V1OutboundInteractionModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.INBOUND_INTERACTION)) {
            return new V1InboundInteractionModel(config, getDescriptor());
        }
        
        if (name.equals(JCAConstants.RESOURCE_ADAPTER)) {
            return new V1ResourceAdapterModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.CONNECTION)) {
            return new V1ConnectionModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.ACTIVATION_SPEC)) {
            return new V1ActivationSpecModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.CONNECTION_SPEC)) {
            return new V1ConnectionSpecModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.INTERACTION_SPEC)) {
            return new V1InteractionSpecModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.OPERATION)) {
            return new V1OperationModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.LISTENER)) {
            return new V1ListenerModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.ENDPOINT)) {
            return new V1EndpointModel(config, getDescriptor());
        }
        if (name.equals(JCAConstants.PROCESSOR)) {
            return new V1ProcessorModel(config, getDescriptor());
        }
        return super.read(config);
    }

}
