/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;

public class EndpointProxy
implements InvocationHandler,
MessageEndpoint {
    private Logger _logger = Logger.getLogger(EndpointProxy.class);
    private final MessageEndpointFactory _messageEndpointFactory;
    private final AbstractInflowEndpoint _delegate;
    private final TransactionManager _transactionManager;
    private final XAResource _xaResource;
    private final ClassLoader _appClassLoader;
    private Transaction _suspendedTx;
    private Transaction _startedTx;
    private boolean _waitAfterDeliveryInvoked = false;
    private Thread _inUseThread = null;
    private boolean _beforeDeliveryInvoked;
    private ClassLoader _origClassLoader;

    public EndpointProxy(MessageEndpointFactory factory, AbstractInflowEndpoint endpoint, TransactionManager tm, XAResource xaResource, ClassLoader appLoader) {
        this._messageEndpointFactory = factory;
        this._delegate = endpoint;
        this._transactionManager = tm;
        this._xaResource = xaResource;
        this._appClassLoader = appLoader;
    }

    public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        if (this._beforeDeliveryInvoked) {
            throw new IllegalStateException("Missing afterDelivery from the previous beforeDelivery for message endpoint " + this._delegate);
        }
        this._beforeDeliveryInvoked = true;
        try {
            this.before(method);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public void afterDelivery() throws ResourceException {
        if (!this._beforeDeliveryInvoked) {
            throw new IllegalStateException("afterDelivery without a previous beforeDelivery for message endpoint " + this._delegate);
        }
        try {
            this.finish(true);
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
        finally {
            this._beforeDeliveryInvoked = false;
            this._waitAfterDeliveryInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this._beforeDeliveryInvoked) {
            try {
                this.finish(false);
            }
            catch (Throwable t) {
                this._logger.warn((Object)"Error in release ", t);
            }
            finally {
                this._beforeDeliveryInvoked = false;
                this._waitAfterDeliveryInvoked = false;
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.acquireThreadLock();
        if (method.getDeclaringClass().equals(MessageEndpoint.class)) {
            return method.invoke((Object)this, args);
        }
        Object ret = null;
        try {
            if (!this._beforeDeliveryInvoked) {
                this.before(method);
            }
            ret = this.delivery(this._delegate, method, args);
        }
        catch (Throwable t) {
            if (!this._beforeDeliveryInvoked) {
                this.finish(false);
            }
            throw t;
        }
        if (!this._beforeDeliveryInvoked) {
            this.finish(true);
        }
        return ret;
    }

    private void before(Method method) throws Exception {
        this.switchToApplicationClassLoader();
        try {
            this.startTransaction(method);
        }
        catch (Exception e) {
            this.resetContextClassLoader();
            throw e;
        }
    }

    private Object delivery(Object delegate, Method method, Object[] args) throws Exception {
        if (this._waitAfterDeliveryInvoked) {
            throw new IllegalStateException("Multiple message delivery between before and after delivery is not allowed for message endpoint " + delegate);
        }
        if (this._beforeDeliveryInvoked) {
            this._waitAfterDeliveryInvoked = true;
        }
        return method.invoke(delegate, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean commit) throws Exception {
        try {
            this.endTransaction(commit);
        }
        finally {
            this.resetContextClassLoader();
            this.releaseThreadLock();
        }
    }

    private void switchToApplicationClassLoader() {
        this._origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this._appClassLoader);
    }

    private void resetContextClassLoader() {
        if (this._origClassLoader != null) {
            this._inUseThread.setContextClassLoader(this._origClassLoader);
            this._origClassLoader = null;
        }
    }

    private void acquireThreadLock() {
        Thread currentThread = Thread.currentThread();
        if (this._inUseThread != null && !this._inUseThread.equals(currentThread)) {
            throw new IllegalStateException("This message endpoint + " + this._delegate + " is already in use by another thread " + this._inUseThread);
        }
        this._inUseThread = currentThread;
    }

    private void releaseThreadLock() {
        this._inUseThread = null;
    }

    private void startTransaction(Method method) throws Exception {
        boolean hasSourceManagedTx;
        boolean endpointRequiresTx = this._messageEndpointFactory.isDeliveryTransacted(method);
        int txStatus = this._transactionManager.getStatus();
        switch (txStatus) {
            case 0: {
                hasSourceManagedTx = true;
                break;
            }
            case 6: {
                hasSourceManagedTx = false;
                break;
            }
            default: {
                throw new IllegalStateException(method + ": New transaction couldn't be started due to the status of existing transaction. Status code=" + txStatus + ". See javax.transaction.Status");
            }
        }
        if (endpointRequiresTx && !hasSourceManagedTx) {
            this._transactionManager.begin();
            this._startedTx = this._transactionManager.getTransaction();
            this._startedTx.enlistResource(this._xaResource);
        } else if (!endpointRequiresTx && hasSourceManagedTx) {
            this._suspendedTx = this._transactionManager.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTransaction(boolean commit) throws Exception {
        block16: {
            Transaction currentTx = null;
            try {
                if (this._startedTx != null) {
                    currentTx = this._transactionManager.getTransaction();
                    if (currentTx == null || !currentTx.equals(this._startedTx)) {
                        this._logger.warn((Object)("Current transaction " + currentTx + " is not same as the " + this._startedTx + " I have started. Replacing it."));
                        this._transactionManager.suspend();
                        this._transactionManager.resume(this._startedTx);
                    } else {
                        currentTx = null;
                    }
                    if (!commit || this._startedTx.getStatus() == 1) {
                        this._transactionManager.rollback();
                    } else {
                        this._transactionManager.commit();
                    }
                    this._startedTx = null;
                }
                if (this._suspendedTx == null) break block16;
                try {
                    this._transactionManager.resume(this._suspendedTx);
                }
                finally {
                    this._suspendedTx = null;
                }
            }
            finally {
                if (currentTx != null) {
                    try {
                        this._transactionManager.resume(currentTx);
                    }
                    catch (Throwable t) {
                        this._logger.warn((Object)("MessageEndpoint " + this._delegate + " failed to resume old transaction " + currentTx));
                    }
                }
            }
        }
    }
}

