/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import javax.resource.cci.IndexedRecord;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.jca.composer.IndexedRecordBindingData;

public class IndexedRecordContextMapper
extends BaseRegexContextMapper<IndexedRecordBindingData> {
    public void mapFrom(IndexedRecordBindingData source, Context context) throws Exception {
        String recordDescription;
        IndexedRecord record = source.getRecord();
        String recordName = record.getRecordName();
        if (recordName != null) {
            context.setProperty("recordName", (Object)recordName, Scope.EXCHANGE).addLabels(new String[]{"jca_message_property"});
        }
        if ((recordDescription = record.getRecordShortDescription()) != null) {
            context.setProperty("recordShortDescription", (Object)recordDescription, Scope.EXCHANGE).addLabels(new String[]{"jca_message_property"});
        }
    }

    public void mapTo(Context context, IndexedRecordBindingData target) throws Exception {
        IndexedRecord record = target.getRecord();
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null) continue;
            if (name.equals("recordName")) {
                record.setRecordName(value.toString());
                continue;
            }
            if (name.equals("recordShortDescription")) {
                record.setRecordShortDescription(value.toString());
                continue;
            }
            if (!this.matches(name)) continue;
            record.add((Object)(name + "=" + value));
        }
    }
}

