/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.deploy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.switchyard.component.jca.EndpointProxy;
import org.switchyard.component.jca.deploy.JCAInflowDeploymentMetaData;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class InboundHandler
extends BaseServiceHandler
implements MessageEndpointFactory {
    private final ResourceAdapter _resourceAdapter;
    private final ActivationSpec _activationSpec;
    private final Class<?> _interface;
    private final AbstractInflowEndpoint _delegate;
    private final TransactionManager _transactionManager;
    private final ClassLoader _appClassLoader;
    private final boolean _transacted;

    public InboundHandler(JCAInflowDeploymentMetaData metadata) {
        this._interface = metadata.getListenerInterface();
        this._resourceAdapter = metadata.getResourceAdapter();
        this._activationSpec = metadata.getActivationSpec();
        this._delegate = metadata.getMessageEndpoint();
        this._transactionManager = metadata.getTransactionManager();
        this._appClassLoader = metadata.getApplicationClassLoader();
        this._transacted = metadata.isDeliveryTransacted();
    }

    public void start() {
        this._delegate.initialize();
        try {
            this._resourceAdapter.endpointActivation((MessageEndpointFactory)this, this._activationSpec);
        }
        catch (ResourceException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public void stop() {
        this._resourceAdapter.endpointDeactivation((MessageEndpointFactory)this, this._activationSpec);
        this._delegate.uninitialize();
    }

    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        EndpointProxy handler = new EndpointProxy(this, this._delegate, this._transactionManager, xaResource, this._appClassLoader);
        return (MessageEndpoint)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this._interface, MessageEndpoint.class}, (InvocationHandler)handler);
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        return this.createEndpoint(xaResource, 0L);
    }

    public boolean isDeliveryTransacted(Method arg0) throws NoSuchMethodException {
        return this._transacted;
    }
}

