/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.endpoint;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.switchyard.Exchange;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.common.selector.OperationSelector;
import org.switchyard.component.jca.composer.JMSBindingData;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;
import org.switchyard.exception.SwitchYardException;

public class JMSEndpoint
extends AbstractInflowEndpoint
implements MessageListener {
    private MessageComposer<JMSBindingData> _composer;
    private OperationSelector<JMSBindingData> _selector;

    @Override
    public void initialize() {
        super.initialize();
        this._composer = this.getMessageComposer(JMSBindingData.class);
        this._selector = this.getOperationSelector(JMSBindingData.class);
    }

    public void onMessage(Message message) {
        try {
            JMSBindingData bindingData = new JMSBindingData(message);
            String operation = this._selector != null ? this._selector.selectOperation((Object)bindingData).getLocalPart() : null;
            Exchange exchange = this.createExchange(operation);
            exchange.send(this._composer.compose((BindingData)bindingData, exchange, true));
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }
}

