/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.switchyard.component.jca.deploy.JCAInflowDeploymentMetaData;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;

public class EndpointProxy
implements InvocationHandler,
MessageEndpoint {
    private Logger _logger = Logger.getLogger(EndpointProxy.class);
    private final MessageEndpointFactory _messageEndpointFactory;
    private final AbstractInflowEndpoint _delegate;
    private final TransactionManager _transactionManager;
    private final XAResource _xaResource;
    private final ClassLoader _appClassLoader;
    private Transaction _suspendedTx;
    private Transaction _startedTx;
    private boolean _waitAfterDeliveryInvoked = false;
    private Thread _inUseThread = null;
    private boolean _beforeDeliveryInvoked;
    private ClassLoader _origClassLoader;
    private boolean _useBatchCommit;
    private int _batchSize;
    private long _batchTimeout;
    private static ThreadLocal<BatchTransactionHelper> _batchHelper = new ThreadLocal();
    private ReentrantLock _deliveryThreadLock = new ReentrantLock();
    private ScheduledExecutorService _scheduler = Executors.newScheduledThreadPool(1);

    public EndpointProxy(JCAInflowDeploymentMetaData metadata, MessageEndpointFactory factory, XAResource xaResource) {
        this._messageEndpointFactory = factory;
        this._delegate = metadata.getMessageEndpoint();
        this._transactionManager = metadata.getTransactionManager();
        this._xaResource = xaResource;
        this._appClassLoader = metadata.getApplicationClassLoader();
        this._useBatchCommit = metadata.useBatchCommit();
        this._batchSize = metadata.getBatchSize();
        this._batchTimeout = metadata.getBatchTimeout();
    }

    public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        if (this._beforeDeliveryInvoked) {
            throw new IllegalStateException("Missing afterDelivery from the previous beforeDelivery for message endpoint " + this._delegate);
        }
        this._beforeDeliveryInvoked = true;
        try {
            this.before(method);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public void afterDelivery() throws ResourceException {
        if (!this._beforeDeliveryInvoked) {
            throw new IllegalStateException("afterDelivery without a previous beforeDelivery for message endpoint " + this._delegate);
        }
        try {
            this.finish(true);
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
        finally {
            this._beforeDeliveryInvoked = false;
            this._waitAfterDeliveryInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this._beforeDeliveryInvoked) {
            try {
                this.finish(false);
            }
            catch (Throwable t) {
                this._logger.warn((Object)"Error in release ", t);
            }
            finally {
                this._beforeDeliveryInvoked = false;
                this._waitAfterDeliveryInvoked = false;
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.acquireThreadLock();
        if (method.getDeclaringClass().equals(MessageEndpoint.class)) {
            return method.invoke((Object)this, args);
        }
        Object ret = null;
        try {
            if (!this._beforeDeliveryInvoked) {
                this.before(method);
            }
            ret = this.delivery(this._delegate, method, args);
        }
        catch (Throwable t) {
            if (!this._beforeDeliveryInvoked) {
                this.finish(false);
            }
            throw t;
        }
        if (!this._beforeDeliveryInvoked) {
            this.finish(true);
        }
        return ret;
    }

    private void before(Method method) throws Exception {
        this.switchToApplicationClassLoader();
        try {
            this.startTransaction(method);
        }
        catch (Exception e) {
            this.resetContextClassLoader();
            throw e;
        }
    }

    private Object delivery(Object delegate, Method method, Object[] args) throws Exception {
        if (this._waitAfterDeliveryInvoked) {
            throw new IllegalStateException("Multiple message delivery between before and after delivery is not allowed for message endpoint " + delegate);
        }
        if (this._beforeDeliveryInvoked) {
            this._waitAfterDeliveryInvoked = true;
        }
        return method.invoke(delegate, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean commit) throws Exception {
        try {
            this.endTransaction(commit);
        }
        finally {
            this.resetContextClassLoader();
            this.releaseThreadLock();
        }
    }

    private void switchToApplicationClassLoader() {
        this._origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this._appClassLoader);
    }

    private void resetContextClassLoader() {
        if (this._origClassLoader != null) {
            this._inUseThread.setContextClassLoader(this._origClassLoader);
            this._origClassLoader = null;
        }
    }

    private void acquireThreadLock() {
        if (this._deliveryThreadLock.isHeldByCurrentThread()) {
            return;
        }
        if (this._inUseThread != null && !this._inUseThread.equals(Thread.currentThread())) {
            throw new IllegalStateException("This message endpoint + " + this._delegate + " is already in use by another thread " + this._inUseThread);
        }
        this._deliveryThreadLock.lock();
        this._inUseThread = Thread.currentThread();
    }

    private void releaseThreadLock() {
        this._inUseThread = null;
        this._deliveryThreadLock.unlock();
    }

    private void startTransaction(Method method) throws Exception {
        boolean hasSourceManagedTx;
        BatchTransactionHelper helper;
        boolean endpointRequiresTx = this._messageEndpointFactory.isDeliveryTransacted(method);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)(Thread.currentThread().getName() + " is invoking startTransaction: currentTx=" + this._transactionManager.getTransaction() + ", _startedTx=" + this._startedTx));
        }
        if (this._useBatchCommit && (helper = _batchHelper.get()) != null && helper.isTransactionActive()) {
            this._startedTx = helper.getAssociatedTransaction();
            return;
        }
        int txStatus = this._transactionManager.getStatus();
        switch (txStatus) {
            case 0: {
                hasSourceManagedTx = true;
                break;
            }
            case 6: {
                hasSourceManagedTx = false;
                break;
            }
            case 3: {
                hasSourceManagedTx = false;
                this._transactionManager.suspend();
                break;
            }
            default: {
                throw new IllegalStateException(method + ": New transaction couldn't be started due to the status of existing transaction. Status code=" + txStatus + ". See javax.transaction.Status");
            }
        }
        if (hasSourceManagedTx && this._useBatchCommit) {
            throw new IllegalStateException("Batch commit mode cannot be used with source managed transaction. Please turn off the batch commit.");
        }
        if (endpointRequiresTx && !hasSourceManagedTx) {
            this._transactionManager.begin();
            this._startedTx = this._transactionManager.getTransaction();
            this._startedTx.enlistResource(this._xaResource);
            if (this._useBatchCommit) {
                BatchTransactionHelper helper2 = new BatchTransactionHelper(this._startedTx);
                helper2.scheduleReaperThread(this._scheduler, this._batchTimeout, TimeUnit.MILLISECONDS);
                _batchHelper.set(helper2);
            }
        } else if (!endpointRequiresTx && hasSourceManagedTx) {
            this._suspendedTx = this._transactionManager.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void endTransaction(boolean commit) throws Exception {
        block21: {
            block22: {
                currentTx = null;
                try {
                    block24: {
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug((Object)(Thread.currentThread().getName() + " is invoking endTransaction: currentTx=" + this._transactionManager.getTransaction() + ", _startedTx=" + this._startedTx));
                        }
                        if (this._startedTx == null) ** GOTO lbl48
                        currentTx = this._transactionManager.getTransaction();
                        if (currentTx == null || !currentTx.equals(this._startedTx)) {
                            this._logger.warn((Object)("Current transaction " + currentTx + " is not same as the " + this._startedTx + " I have started. Replacing it."));
                            this._transactionManager.suspend();
                            this._transactionManager.resume(this._startedTx);
                        } else {
                            currentTx = null;
                        }
                        helper = EndpointProxy._batchHelper.get();
                        if (commit && this._startedTx.getStatus() != 1) break block24;
                        this._transactionManager.rollback();
                        if (this._useBatchCommit) {
                            helper.cancelScheduledReaperThread();
                        }
                        ** GOTO lbl47
                    }
                    if (!this._useBatchCommit) break block21;
                    if (helper.getCounter() + 1 < this._batchSize) {
                        helper.setCounter(helper.getCounter() + 1);
                    } else {
                        this._transactionManager.commit();
                        helper.cancelScheduledReaperThread();
                    }
                    this._startedTx = null;
                    if (currentTx == null) break block22;
                }
                catch (Throwable var6_7) {
                    if (currentTx != null) {
                        try {
                            this._transactionManager.resume(currentTx);
                        }
                        catch (Throwable t) {
                            this._logger.warn((Object)("MessageEndpoint " + this._delegate + " failed to resume old transaction " + currentTx));
                        }
                    }
                    throw var6_7;
                }
                try {
                    this._transactionManager.resume(currentTx);
                }
                catch (Throwable t) {
                    this._logger.warn((Object)("MessageEndpoint " + this._delegate + " failed to resume old transaction " + currentTx));
                }
            }
            return;
        }
        this._transactionManager.commit();
lbl47:
        // 2 sources

        this._startedTx = null;
lbl48:
        // 2 sources

        if (this._suspendedTx != null) {
            try {
                this._transactionManager.resume(this._suspendedTx);
            }
            finally {
                this._suspendedTx = null;
            }
        }
        ** if (currentTx == null) goto lbl-1000
lbl-1000:
        // 1 sources

        {
            try {
                this._transactionManager.resume(currentTx);
            }
            catch (Throwable t) {
                this._logger.warn((Object)("MessageEndpoint " + this._delegate + " failed to resume old transaction " + currentTx));
            }
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    private class BatchTransactionHelper
    extends Thread {
        private Transaction _transaction;
        private int _counter = 0;
        private ScheduledFuture<?> _future;

        public BatchTransactionHelper(Transaction tx) {
            this._transaction = tx;
        }

        public void setCounter(int counter) {
            this._counter = counter;
        }

        public int getCounter() {
            return this._counter;
        }

        public boolean isTransactionActive() {
            try {
                return this._transaction.getStatus() == 0;
            }
            catch (Exception e) {
                EndpointProxy.this._logger.warn((Object)"Failed to retrieve transaction status", (Throwable)e);
                return false;
            }
        }

        public Transaction getAssociatedTransaction() {
            return this._transaction;
        }

        public void scheduleReaperThread(ScheduledExecutorService service, long delay, TimeUnit unit) {
            this._future = service.schedule(this, delay, unit);
        }

        public void cancelScheduledReaperThread() {
            if (this._future != null) {
                this._future.cancel(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EndpointProxy.this._deliveryThreadLock.lock();
            try {
                if (this._transaction.getStatus() == 0) {
                    EndpointProxy.this._transactionManager.resume(this._transaction);
                    EndpointProxy.this._transactionManager.commit();
                    EndpointProxy.this._logger.info((Object)("Transaction has been committed by reaper thread [" + this._counter + "]"));
                    this._counter = 0;
                }
            }
            catch (Exception e) {
                EndpointProxy.this._logger.error((Object)"Failed to commit expiring transaction", (Throwable)e);
            }
            finally {
                EndpointProxy.this._deliveryThreadLock.unlock();
            }
        }
    }
}

