/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.processor.cci;

import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Streamable;
import org.switchyard.SwitchYardException;
import org.switchyard.component.jca.composer.RecordBindingData;
import org.switchyard.component.jca.processor.cci.IndexedRecordHandler;
import org.switchyard.component.jca.processor.cci.MappedRecordHandler;
import org.switchyard.component.jca.processor.cci.RecordHandler;
import org.switchyard.component.jca.processor.cci.StreamableRecordHandler;

public final class RecordHandlerFactory {
    private RecordHandlerFactory() {
    }

    public static RecordHandler<? extends RecordBindingData<?>> createRecordHandler(Class<?> recordType, ClassLoader loader) {
        if (recordType.equals(MappedRecord.class)) {
            return new MappedRecordHandler();
        }
        if (recordType.equals(IndexedRecord.class)) {
            return new IndexedRecordHandler();
        }
        if (recordType.equals(Streamable.class)) {
            return new StreamableRecordHandler();
        }
        try {
            Class<?> clazz = loader.loadClass(RecordHandlerFactory.class.getPackage().getName() + "." + recordType.getSimpleName() + "RecordHandler");
            return (RecordHandler)clazz.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("record type '" + recordType.getName() + "is not supported");
        }
    }
}

