/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.processor;

import java.io.InputStream;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.jca.JCALogger;
import org.switchyard.component.jca.JCAMessages;
import org.switchyard.component.jca.composer.JMSBindingData;
import org.switchyard.component.jca.processor.AbstractOutboundProcessor;

public class JMSProcessor
extends AbstractOutboundProcessor {
    public static final String KEY_USERNAME = "userName";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_TRANSACTED = "transacted";
    public static final String KEY_ACKNOWLEDGE_MODE = "acknowledgeMode";
    public static final String KEY_DESTINATION = "destination";
    public static final String KEY_MESSAGE_TYPE = "messageType";
    public static final String KEY_DESTINATION_JNDI_PROVIDER_URL = "destinationJndiPropertiesFileName";
    private Logger _logger = Logger.getLogger(JMSProcessor.class);
    private String _userName;
    private String _password;
    private String _transacted;
    private boolean _txEnabled;
    private String _destination;
    private String _acknowledgeMode;
    private int _ackMode;
    private ConnectionFactory _connectionFactory;
    private Destination _jmsDestination;
    private MessageComposer<JMSBindingData> _composer;
    private MessageType _outMessageType = MessageType.Object;
    private String _destinationJndiPropertiesFileName;
    private Properties _destinationJndiProperties;

    @Override
    public AbstractOutboundProcessor setConnectionSpec(String name, Properties props) {
        return this;
    }

    @Override
    public AbstractOutboundProcessor setInteractionSpec(String name, Properties props) {
        return this;
    }

    @Override
    public void initialize() {
        this._txEnabled = Boolean.parseBoolean(this._transacted);
        this._ackMode = this._acknowledgeMode == null || this._acknowledgeMode.equals("") ? 1 : Integer.parseInt(this._acknowledgeMode);
        if (this._destination == null) {
            throw JCAMessages.MESSAGES.destinationPropertyMustBeSpecifiedInProcessorProperties();
        }
        this._composer = this.getMessageComposer(JMSBindingData.class);
        try {
            InitialContext cfic = null;
            cfic = this.getJndiProperties() != null ? new InitialContext(this.getJndiProperties()) : new InitialContext();
            this._connectionFactory = (ConnectionFactory)cfic.lookup(this.getConnectionFactoryJNDIName());
            InitialContext destic = null;
            if (this.getDestinationJndiProperties() != null) {
                cfic.close();
                destic = new InitialContext(this.getDestinationJndiProperties());
            } else {
                destic = cfic;
            }
            this._jmsDestination = (Destination)destic.lookup(this._destination);
            destic.close();
        }
        catch (Exception e) {
            throw JCAMessages.MESSAGES.failedToInitialize(this.getClass().getName(), e);
        }
    }

    @Override
    public void uninitialize() {
        this._connectionFactory = null;
    }

    @Override
    public Message process(Exchange exchange) throws HandlerException {
        Connection connection = null;
        Session session = null;
        try {
            StreamMessage msg;
            connection = this._userName != null ? this._connectionFactory.createConnection(this._userName, this._password) : this._connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(this._txEnabled, this._ackMode);
            MessageProducer producer = session.createProducer(this._jmsDestination);
            switch (this._outMessageType) {
                case Stream: {
                    msg = session.createStreamMessage();
                    break;
                }
                case Map: {
                    msg = session.createMapMessage();
                    break;
                }
                case Text: {
                    msg = session.createTextMessage();
                    break;
                }
                case Bytes: {
                    msg = session.createBytesMessage();
                    break;
                }
                case Plain: {
                    msg = session.createMessage();
                    break;
                }
                default: {
                    msg = session.createObjectMessage();
                }
            }
            producer.send(((JMSBindingData)this._composer.decompose(exchange, (BindingData)new JMSBindingData((javax.jms.Message)msg))).getMessage());
            Message message = null;
            return message;
        }
        catch (Exception e) {
            throw JCAMessages.MESSAGES.failedToProcessJMSOutboundInteraction(e);
        }
        finally {
            block18: {
                try {
                    if (session != null) {
                        session.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (JMSException e) {
                    JCALogger.ROOT_LOGGER.failedToCloseJMSSessionconnection(e.getMessage());
                    if (!this._logger.isDebugEnabled()) break block18;
                    e.printStackTrace();
                }
            }
        }
    }

    public void setDestination(String name) {
        this._destination = name;
    }

    public void setUsername(String user) {
        this._userName = user;
    }

    public void setPassword(String passwd) {
        this._password = passwd;
    }

    public void setTransacted(String tx) {
        this._transacted = tx;
    }

    public void setAcknowledgeMode(String ack) {
        this._acknowledgeMode = ack;
    }

    public void setMessageType(String type) {
        this._outMessageType = MessageType.valueOf(type);
    }

    public void setDestinationJndiPropertiesFileName(String name) {
        this._destinationJndiPropertiesFileName = name;
    }

    public Properties getDestinationJndiProperties() {
        if (this._destinationJndiPropertiesFileName != null && this._destinationJndiProperties == null) {
            try {
                InputStream is = Classes.getResourceAsStream((String)this._destinationJndiPropertiesFileName);
                Properties props = new Properties();
                props.load(is);
                is.close();
                this._destinationJndiProperties = props;
            }
            catch (Exception e) {
                JCALogger.ROOT_LOGGER.failedToLoadJndiPropertiesFile(this._destinationJndiPropertiesFileName, e);
            }
        }
        return this._destinationJndiProperties;
    }

    private static enum MessageType {
        Stream,
        Map,
        Text,
        Object,
        Bytes,
        Plain;

    }
}

