/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.selector;

import java.io.StringReader;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.switchyard.component.common.selector.BaseOperationSelector;
import org.switchyard.component.jca.JCAMessages;
import org.switchyard.component.jca.composer.JMSBindingData;
import org.switchyard.config.model.selector.OperationSelectorModel;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class JMSOperationSelector
extends BaseOperationSelector<JMSBindingData> {
    public static final String KEY = "operationSelector";

    public JMSOperationSelector(OperationSelectorModel model) {
        super(model);
    }

    protected Document extractDomDocument(JMSBindingData binding) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(this.extractString(binding)));
        return builder.parse(is);
    }

    protected String extractString(JMSBindingData binding) throws Exception {
        Message content = binding.getMessage();
        if (content instanceof TextMessage) {
            return ((TextMessage)TextMessage.class.cast(content)).getText();
        }
        if (content instanceof BytesMessage) {
            BytesMessage sourceBytes = (BytesMessage)BytesMessage.class.cast(content);
            if (sourceBytes.getBodyLength() > Integer.MAX_VALUE) {
                throw JCAMessages.MESSAGES.theSizeOfMessageContentExceedsBytesThatIsNotSupportedByThisOperationSelector(new String("2147483647"));
            }
            byte[] bytearr = new byte[(int)sourceBytes.getBodyLength()];
            sourceBytes.readBytes(bytearr);
            return new String(bytearr);
        }
        if (content instanceof ObjectMessage) {
            ObjectMessage sourceObj = (ObjectMessage)ObjectMessage.class.cast(content);
            return (String)String.class.cast(sourceObj.getObject());
        }
        if (content instanceof MapMessage) {
            MapMessage sourceMap = (MapMessage)MapMessage.class.cast(content);
            return sourceMap.getString(KEY);
        }
        return content.getStringProperty(KEY);
    }
}

