/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.deploy;

import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.component.jca.processor.AbstractOutboundProcessor;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.label.BehaviorLabel;

public class OutboundHandler
extends BaseServiceHandler {
    private AbstractOutboundProcessor _processor;
    private final String _bindingName;
    private final String _referenceName;

    public OutboundHandler(AbstractOutboundProcessor processor, ServiceDomain domain) {
        super(domain);
        this._processor = processor;
        this._bindingName = processor.getJCABindingModel().getName();
        this._referenceName = processor.getJCABindingModel().getReference().getName();
    }

    protected void doStart() {
        this._processor.initialize();
    }

    protected void doStop() {
        this._processor.uninitialize();
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._bindingName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        if (this.getState() != Lifecycle.State.STARTED) {
            throw new HandlerException(String.format("Reference binding \"%s/%s\" is not started.", this._referenceName, this._bindingName));
        }
        Message out = this._processor.process(exchange);
        if (exchange.getContract().getProviderOperation().getExchangePattern() == ExchangePattern.IN_OUT) {
            exchange.send(out);
        }
    }
}

