/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.processor;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.RecordFactory;
import org.apache.log4j.Logger;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.SwitchYardException;
import org.switchyard.component.jca.processor.AbstractOutboundProcessor;
import org.switchyard.component.jca.processor.cci.RecordHandler;
import org.switchyard.component.jca.processor.cci.RecordHandlerFactory;

public class CCIProcessor
extends AbstractOutboundProcessor {
    public static final String DEFAULT_RECORD_TYPE = "javax.resource.cci.MappedRecord";
    private Logger _logger = Logger.getLogger(CCIProcessor.class);
    private String _recordClassName;
    private ConnectionSpec _connectionSpec;
    private InteractionSpec _interactionSpec;
    private ConnectionFactory _connectionFactory;
    private RecordHandler<?> _recordHandler;

    @Override
    public AbstractOutboundProcessor setConnectionSpec(String name, Properties props) {
        try {
            Class<?> clazz = this.getApplicationClassLoader().loadClass(name);
            this._connectionSpec = (ConnectionSpec)clazz.newInstance();
            if (!props.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)this._connectionSpec, (Properties)props);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not initialize ConnectionSpec", e);
        }
        return this;
    }

    @Override
    public AbstractOutboundProcessor setInteractionSpec(String name, Properties props) {
        try {
            Class<?> clazz = this.getApplicationClassLoader().loadClass(name);
            this._interactionSpec = (InteractionSpec)clazz.newInstance();
            if (!props.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)this._interactionSpec, (Properties)props);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not initialize InteractionSpec", e);
        }
        return this;
    }

    @Override
    public void initialize() {
        try {
            Class<?> clazz = this.getApplicationClassLoader().loadClass(this._recordClassName);
            this._recordHandler = RecordHandlerFactory.createRecordHandler(clazz, this.getApplicationClassLoader()).setJCABindingModel(this.getJCABindingModel()).setInteractionSpec(this._interactionSpec);
            InitialContext ic = new InitialContext();
            this._connectionFactory = (ConnectionFactory)ic.lookup(this.getConnectionFactoryJNDIName());
        }
        catch (Exception e) {
            throw new SwitchYardException("Failed to initialize " + this.getClass().getName(), (Throwable)e);
        }
        try {
            RecordFactory factory = this._connectionFactory.getRecordFactory();
            this._recordHandler.setRecordFactory(factory);
        }
        catch (ResourceException e) {
            this._logger.warn((Object)("Failed to get RecordFactory: " + e.getMessage()));
        }
    }

    @Override
    public void uninitialize() {
        this._connectionFactory = null;
    }

    @Override
    public Message process(Exchange exchange) throws HandlerException {
        Connection connection = null;
        Interaction interaction = null;
        try {
            connection = this._connectionSpec != null ? this._connectionFactory.getConnection(this._connectionSpec) : this._connectionFactory.getConnection();
            interaction = connection.createInteraction();
            Message message = this._recordHandler.handle(exchange, connection, interaction);
            return message;
        }
        catch (Exception e) {
            throw new HandlerException("Failed to process CCI outbound interaction", (Throwable)e);
        }
        finally {
            block11: {
                try {
                    if (interaction != null) {
                        interaction.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (ResourceException e) {
                    this._logger.warn((Object)("Failed to close Interaction/Connection: " + e.getMessage()));
                    if (!this._logger.isDebugEnabled()) break block11;
                    e.printStackTrace();
                }
            }
        }
    }

    public void setRecordClassName(String name) {
        this._recordClassName = name;
    }
}

