/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.endpoint;

import java.io.InputStream;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.naming.InitialContext;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangeState;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.jca.JCALogger;
import org.switchyard.component.jca.JCAMessages;
import org.switchyard.component.jca.composer.JMSBindingData;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;
import org.switchyard.selector.OperationSelector;

public class JMSEndpoint
extends AbstractInflowEndpoint
implements MessageListener {
    public static final String CONTEXT_PROPERTY_PREFIX = "org.switchyard.component.jca.endpoint.";
    public static final String KEY_JNDI_PROPERTIES_FILE = "jndiPropertiesFileName";
    public static final String KEY_DESTINATION_JNDI_PROPERTIES_FILE = "destinationJndiPropertiesFileName";
    public static final String KEY_CONNECTION_FACTORY_JNDI_NAME = "connectionFactoryJndiName";
    public static final String KEY_REPLY_TO = "replyTo";
    public static final String KEY_FAULT_TO = "faultTo";
    public static final String KEY_MESSAGE_TYPE = "messageType";
    public static final String KEY_USERNAME = "userName";
    public static final String KEY_PASSWORD = "password";
    private MessageComposer<JMSBindingData> _composer;
    private OperationSelector<JMSBindingData> _selector;
    private String _jndiPropertiesFileName;
    private String _destinationJndiPropertiesFileName;
    private String _connectionFactoryJNDIName;
    private String _defaultFaultTo;
    private String _defaultReplyTo;
    private String _userName;
    private String _password;
    private Properties _jndiProperties;
    private Properties _destinationJndiProperties;
    private ConnectionFactory _connectionFactory;
    private Destination _faultToJMSDestination;
    private Destination _replyToJMSDestination;
    private MessageType _defaultOutMessageType = MessageType.Object;

    @Override
    public void initialize() {
        super.initialize();
        this._composer = this.getMessageComposer(JMSBindingData.class);
        this._selector = this.getOperationSelector(JMSBindingData.class);
        try {
            InitialContext cfic = null;
            cfic = this.getJndiProperties() != null ? new InitialContext(this.getJndiProperties()) : new InitialContext();
            if (this._connectionFactoryJNDIName != null) {
                this._connectionFactory = (ConnectionFactory)cfic.lookup(this._connectionFactoryJNDIName);
            }
            InitialContext destic = null;
            if (this.getDestinationJndiProperties() != null) {
                cfic.close();
                destic = new InitialContext(this.getDestinationJndiProperties());
            } else {
                destic = cfic;
            }
            if (this._defaultFaultTo != null) {
                try {
                    this._faultToJMSDestination = (Destination)destic.lookup(this._defaultFaultTo);
                }
                catch (Exception e) {
                    JCALogger.ROOT_LOGGER.destinationNotFound(this._defaultFaultTo, KEY_FAULT_TO);
                }
            }
            if (this._defaultReplyTo != null) {
                try {
                    this._replyToJMSDestination = (Destination)destic.lookup(this._defaultReplyTo);
                }
                catch (Exception e) {
                    JCALogger.ROOT_LOGGER.destinationNotFound(this._defaultReplyTo, KEY_REPLY_TO);
                }
            }
            destic.close();
        }
        catch (Exception e) {
            throw JCAMessages.MESSAGES.failedToInitialize(this.getClass().getName(), e);
        }
    }

    public void onMessage(Message message) {
        try {
            JMSBindingData bindingData = new JMSBindingData(message);
            String operation = this._selector != null ? this._selector.selectOperation((Object)bindingData).getLocalPart() : null;
            SynchronousInOutHandler replyHandler = new SynchronousInOutHandler();
            Exchange exchange = this.createExchange(operation, (ExchangeHandler)replyHandler);
            exchange.send(this._composer.compose((BindingData)bindingData, exchange));
            Context context = exchange.getContext();
            Destination faultTo = this.getFaultToDestination(context);
            Destination replyTo = this.getReplyToDestination(context);
            if (faultTo != null && ExchangeState.FAULT.equals((Object)exchange.getState())) {
                if (exchange.getMessage() != null) {
                    this.sendJMSMessage(faultTo, exchange, this.getOutputMessageType(context));
                }
            } else if (replyTo != null && ExchangePattern.IN_OUT.equals((Object)exchange.getPattern()) && (exchange = replyHandler.waitForOut()).getMessage() != null) {
                this.sendJMSMessage(replyTo, exchange, this.getOutputMessageType(context));
            }
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendJMSMessage(Destination destination, Exchange exchange, MessageType type) {
        Connection connection = null;
        try {
            StreamMessage msg;
            connection = this._connectionFactory.createConnection(this._userName, this._password);
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(destination);
            switch (type) {
                case Stream: {
                    msg = session.createStreamMessage();
                    break;
                }
                case Map: {
                    msg = session.createMapMessage();
                    break;
                }
                case Text: {
                    msg = session.createTextMessage();
                    break;
                }
                case Bytes: {
                    msg = session.createBytesMessage();
                    break;
                }
                case Plain: {
                    msg = session.createMessage();
                    break;
                }
                default: {
                    msg = session.createObjectMessage();
                }
            }
            producer.send(((JMSBindingData)this._composer.decompose(exchange, (BindingData)new JMSBindingData((Message)msg))).getMessage());
        }
        catch (Exception e) {
            JCALogger.ROOT_LOGGER.failedToSendMessage(destination.toString());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        }
    }

    protected Destination getReplyToDestination(Context ctx) {
        String key = "org.switchyard.component.jca.endpoint.replyTo";
        if (ctx.getProperty(key) != null) {
            String destName = (String)ctx.getPropertyValue(key);
            try {
                return this.getDestinationFromContext(destName);
            }
            catch (Exception e) {
                if (this._defaultReplyTo != null) {
                    JCALogger.ROOT_LOGGER.contextDestinationNotFound(destName, this._defaultReplyTo);
                }
                JCALogger.ROOT_LOGGER.destinationNotFound(destName, KEY_REPLY_TO);
            }
        }
        return this._replyToJMSDestination;
    }

    protected Destination getFaultToDestination(Context ctx) {
        String key = "org.switchyard.component.jca.endpoint.faultTo";
        if (ctx.getProperty(key) != null) {
            String destName = (String)ctx.getPropertyValue(key);
            try {
                return this.getDestinationFromContext(destName);
            }
            catch (Exception e) {
                if (this._defaultFaultTo != null) {
                    JCALogger.ROOT_LOGGER.contextDestinationNotFound(destName, this._defaultFaultTo);
                }
                JCALogger.ROOT_LOGGER.destinationNotFound(destName, KEY_FAULT_TO);
            }
        }
        return this._faultToJMSDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination getDestinationFromContext(String destName) throws Exception {
        InitialContext ic = null;
        try {
            ic = this.getDestinationJndiProperties() != null ? new InitialContext(this.getDestinationJndiProperties()) : (this.getJndiProperties() != null ? new InitialContext(this.getJndiProperties()) : new InitialContext());
            Destination destination = (Destination)ic.lookup(destName);
            return destination;
        }
        finally {
            if (ic != null) {
                try {
                    ic.close();
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        }
    }

    protected MessageType getOutputMessageType(Context ctx) {
        String key = "org.switchyard.component.jca.endpoint.messageType";
        if (ctx.getProperty(key) != null) {
            return MessageType.valueOf(ctx.getPropertyValue(key).toString());
        }
        return this._defaultOutMessageType;
    }

    public void setConnectionFactoryJNDIName(String name) {
        this._connectionFactoryJNDIName = name;
    }

    public void setReplyTo(String name) {
        this._defaultReplyTo = name;
    }

    public void setFaultTo(String name) {
        this._defaultFaultTo = name;
    }

    public void setUsername(String user) {
        this._userName = user;
    }

    public void setPassword(String passwd) {
        this._password = passwd;
    }

    public void setMessageType(String type) {
        this._defaultOutMessageType = MessageType.valueOf(type);
    }

    public void setJndiPropertiesFileName(String name) {
        this._jndiPropertiesFileName = name;
    }

    public Properties getJndiProperties() {
        if (this._jndiPropertiesFileName != null && this._jndiProperties == null) {
            try {
                InputStream is = Classes.getResourceAsStream((String)this._jndiPropertiesFileName);
                Properties props = new Properties();
                props.load(is);
                is.close();
                this._jndiProperties = props;
            }
            catch (Exception e) {
                JCALogger.ROOT_LOGGER.failedToLoadJndiPropertiesFile(this._jndiPropertiesFileName, e);
            }
        }
        return this._jndiProperties;
    }

    public void setDestinationJndiPropertiesFileName(String name) {
        this._destinationJndiPropertiesFileName = name;
    }

    public Properties getDestinationJndiProperties() {
        if (this._destinationJndiPropertiesFileName != null && this._destinationJndiProperties == null) {
            try {
                InputStream is = Classes.getResourceAsStream((String)this._destinationJndiPropertiesFileName);
                Properties props = new Properties();
                props.load(is);
                is.close();
                this._destinationJndiProperties = props;
            }
            catch (Exception e) {
                JCALogger.ROOT_LOGGER.failedToLoadJndiPropertiesFile(this._destinationJndiPropertiesFileName, e);
            }
        }
        return this._destinationJndiProperties;
    }

    private static enum MessageType {
        Stream,
        Map,
        Text,
        Object,
        Bytes,
        Plain;

    }
}

