/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.endpoint;

import java.io.InputStream;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangeState;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.jca.JCALogger;
import org.switchyard.component.jca.JCAMessages;
import org.switchyard.component.jca.composer.JMSBindingData;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;
import org.switchyard.selector.OperationSelector;

public class JMSEndpoint
extends AbstractInflowEndpoint
implements MessageListener {
    public static final String CONTEXT_PROPERTY_PREFIX = "org.switchyard.component.jca.endpoint.";
    public static final String KEY_JNDI_PROPERTIES_FILE = "jndiPropertiesFileName";
    public static final String KEY_DESTINATION_JNDI_PROPERTIES_FILE = "destinationJndiPropertiesFileName";
    public static final String KEY_CONNECTION_FACTORY_JNDI_NAME = "connectionFactoryJndiName";
    public static final String KEY_DESTINATION_TYPE = "destinationType";
    public static final String KEY_REPLY_TO = "replyTo";
    public static final String KEY_FAULT_TO = "faultTo";
    public static final String KEY_MESSAGE_TYPE = "messageType";
    public static final String KEY_USERNAME = "userName";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_DELIVERY_MODE = "deliveryMode";
    public static final String KEY_PRIORITY = "priority";
    public static final String KEY_TIME_TO_LIVE = "timeToLive";
    private Logger _logger = Logger.getLogger(JMSEndpoint.class);
    private MessageComposer<JMSBindingData> _composer;
    private OperationSelector<JMSBindingData> _selector;
    private String _jndiPropertiesFileName;
    private String _destinationJndiPropertiesFileName;
    private String _connectionFactoryJNDIName;
    private DestinationType _defaultDestinationType = DestinationType.JNDI;
    private String _defaultFaultTo;
    private String _defaultReplyTo;
    private String _userName;
    private String _password;
    private Properties _jndiProperties;
    private Properties _destinationJndiProperties;
    private ConnectionFactory _connectionFactory;
    private Destination _defaultFaultToJMSDestination;
    private Destination _defaultReplyToJMSDestination;
    private MessageType _defaultOutMessageType = MessageType.Object;

    @Override
    public void initialize() {
        block12: {
            super.initialize();
            this._composer = this.getMessageComposer(JMSBindingData.class);
            this._selector = this.getOperationSelector(JMSBindingData.class);
            try {
                InitialContext cfic = null;
                cfic = this.getJndiProperties() != null ? new InitialContext(this.getJndiProperties()) : new InitialContext();
                if (this._connectionFactoryJNDIName != null) {
                    this._connectionFactory = (ConnectionFactory)cfic.lookup(this._connectionFactoryJNDIName);
                }
                if (this._defaultDestinationType != DestinationType.JNDI) break block12;
                InitialContext destic = null;
                if (this.getDestinationJndiProperties() != null) {
                    cfic.close();
                    destic = new InitialContext(this.getDestinationJndiProperties());
                } else {
                    destic = cfic;
                }
                if (this._defaultFaultTo != null) {
                    try {
                        this._defaultFaultToJMSDestination = (Destination)destic.lookup(this._defaultFaultTo);
                    }
                    catch (Exception e) {
                        JCALogger.ROOT_LOGGER.destinationNotFound(this._defaultFaultTo, KEY_FAULT_TO);
                    }
                }
                if (this._defaultReplyTo != null) {
                    try {
                        this._defaultReplyToJMSDestination = (Destination)destic.lookup(this._defaultReplyTo);
                    }
                    catch (Exception e) {
                        JCALogger.ROOT_LOGGER.destinationNotFound(this._defaultReplyTo, KEY_REPLY_TO);
                    }
                }
                destic.close();
            }
            catch (Exception e) {
                throw JCAMessages.MESSAGES.failedToInitialize(this.getClass().getName(), e);
            }
        }
        if (this._logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder().append("Initialized with: {").append("Connection Factory:").append(this._connectionFactoryJNDIName).append(", Destination Type:").append((Object)this._defaultDestinationType).append(", replyTo Name:").append(this._defaultReplyTo).append(", faultTo Name:").append(this._defaultReplyTo).append(", User Name:").append(this._userName).append(", Output Message Type:").append((Object)this._defaultOutMessageType).append(", JNDI Properties File:").append(this._jndiPropertiesFileName).append(", Destination JNDI Properties File:").append(this._destinationJndiPropertiesFileName).append("}");
            this._logger.debug((Object)msg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            JMSBindingData bindingData = new JMSBindingData(message);
            String operation = this._selector != null ? this._selector.selectOperation((Object)bindingData).getLocalPart() : null;
            SynchronousInOutHandler replyHandler = new SynchronousInOutHandler();
            Exchange exchange = this.createExchange(operation, (ExchangeHandler)replyHandler);
            exchange.send(this._composer.compose((BindingData)bindingData, exchange));
            if (this._connectionFactory == null) {
                return;
            }
            Context context = exchange.getContext();
            Connection connection = null;
            try {
                connection = this._userName != null ? this._connectionFactory.createConnection(this._userName, this._password) : this._connectionFactory.createConnection();
                Session session = connection.createSession(false, 1);
                Destination faultTo = this.getFaultToDestinationFromContext(session, context);
                Destination replyTo = this.getReplyToDestinationFromContext(session, context);
                if (faultTo != null && ExchangeState.FAULT.equals((Object)exchange.getState())) {
                    if (exchange.getMessage() != null) {
                        this.sendJMSMessage(session, faultTo, exchange, this.getOutputMessageTypeFromContext(context));
                    }
                } else if (replyTo != null && ExchangePattern.IN_OUT.equals((Object)exchange.getPattern()) && (exchange = replyHandler.waitForOut()).getMessage() != null) {
                    this.sendJMSMessage(session, replyTo, exchange, this.getOutputMessageTypeFromContext(context));
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    protected void sendJMSMessage(Session session, Destination destination, Exchange exchange, MessageType type) {
        block9: {
            try {
                StreamMessage msg;
                MessageProducer producer = session.createProducer(destination);
                Context context = exchange.getContext();
                switch (type) {
                    case Stream: {
                        msg = session.createStreamMessage();
                        break;
                    }
                    case Map: {
                        msg = session.createMapMessage();
                        break;
                    }
                    case Text: {
                        msg = session.createTextMessage();
                        break;
                    }
                    case Bytes: {
                        msg = session.createBytesMessage();
                        break;
                    }
                    case Plain: {
                        msg = session.createMessage();
                        break;
                    }
                    default: {
                        msg = session.createObjectMessage();
                    }
                }
                producer.send(((JMSBindingData)this._composer.decompose(exchange, (BindingData)new JMSBindingData((Message)msg))).getMessage(), this.getDeliveryModeFromContext(context, producer), this.getPriorityFromContext(context, producer), this.getTimeToLiveFromContext(context, producer));
            }
            catch (Exception e) {
                JCALogger.ROOT_LOGGER.failedToSendMessage(destination.toString(), e.getMessage());
                if (!this._logger.isDebugEnabled()) break block9;
                this._logger.debug((Object)e);
            }
        }
    }

    protected Destination getReplyToDestinationFromContext(Session session, Context ctx) {
        Destination replyToDestination;
        block18: {
            block17: {
                replyToDestination = null;
                String key = "org.switchyard.component.jca.endpoint.replyTo";
                if (ctx.getProperty(key) != null) {
                    String replyToName = (String)ctx.getPropertyValue(key);
                    DestinationType replyToType = this.getDestinationTypeFromContext(ctx);
                    try {
                        switch (replyToType) {
                            case JNDI: {
                                replyToDestination = this.lookupDestinationFromJNDI(replyToName);
                                break;
                            }
                            case Queue: {
                                replyToDestination = session.createQueue(replyToName);
                                break;
                            }
                            case Topic: {
                                replyToDestination = session.createTopic(replyToName);
                            }
                        }
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug((Object)("replyTo is set to '" + replyToName + "'"));
                        }
                    }
                    catch (Exception e) {
                        JCALogger.ROOT_LOGGER.contextDestinationNotFound(replyToName, this._defaultReplyTo);
                        if (!this._logger.isDebugEnabled()) break block17;
                        this._logger.debug((Object)e);
                    }
                }
            }
            if (replyToDestination == null) {
                try {
                    switch (this._defaultDestinationType) {
                        case JNDI: {
                            replyToDestination = this._defaultReplyToJMSDestination;
                            break;
                        }
                        case Queue: {
                            replyToDestination = session.createQueue(this._defaultReplyTo);
                            break;
                        }
                        case Topic: {
                            replyToDestination = session.createTopic(this._defaultReplyTo);
                        }
                    }
                }
                catch (Exception e) {
                    JCALogger.ROOT_LOGGER.destinationNotFound(this._defaultReplyTo, KEY_REPLY_TO);
                    if (!this._logger.isDebugEnabled()) break block18;
                    this._logger.debug((Object)e);
                }
            }
        }
        return replyToDestination;
    }

    protected Destination getFaultToDestinationFromContext(Session session, Context ctx) {
        Destination faultToDestination;
        block18: {
            block17: {
                faultToDestination = null;
                String key = "org.switchyard.component.jca.endpoint.faultTo";
                if (ctx.getProperty(key) != null) {
                    String faultToName = (String)ctx.getPropertyValue(key);
                    DestinationType faultToType = this.getDestinationTypeFromContext(ctx);
                    try {
                        switch (faultToType) {
                            case JNDI: {
                                faultToDestination = this.lookupDestinationFromJNDI(faultToName);
                                break;
                            }
                            case Queue: {
                                faultToDestination = session.createQueue(faultToName);
                                break;
                            }
                            case Topic: {
                                faultToDestination = session.createTopic(faultToName);
                            }
                        }
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug((Object)("faultTo is set to '" + faultToName + "'"));
                        }
                    }
                    catch (Exception e) {
                        JCALogger.ROOT_LOGGER.contextDestinationNotFound(faultToName, this._defaultFaultTo);
                        if (!this._logger.isDebugEnabled()) break block17;
                        this._logger.debug((Object)e);
                    }
                }
            }
            if (faultToDestination == null) {
                try {
                    switch (this._defaultDestinationType) {
                        case JNDI: {
                            faultToDestination = this._defaultFaultToJMSDestination;
                            break;
                        }
                        case Queue: {
                            faultToDestination = session.createQueue(this._defaultFaultTo);
                            break;
                        }
                        case Topic: {
                            faultToDestination = session.createTopic(this._defaultFaultTo);
                        }
                    }
                }
                catch (Exception e) {
                    JCALogger.ROOT_LOGGER.destinationNotFound(this._defaultFaultTo, KEY_FAULT_TO);
                    if (!this._logger.isDebugEnabled()) break block18;
                    this._logger.debug((Object)e);
                }
            }
        }
        return faultToDestination;
    }

    protected DestinationType getDestinationTypeFromContext(Context ctx) {
        String type;
        DestinationType ctxType;
        DestinationType destType = this._defaultDestinationType;
        String key = "org.switchyard.component.jca.endpoint.destinationType";
        if (ctx.getProperty(key) != null && (ctxType = this.parseDestinationType(type = (String)ctx.getPropertyValue(key))) != null) {
            destType = ctxType;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Destination type is set to '" + destType.toString() + "'"));
            }
        }
        return destType;
    }

    protected Destination lookupOrCreateDestination(Session session, DestinationType type, String destName) throws Exception {
        switch (type) {
            case JNDI: {
                return this.lookupDestinationFromJNDI(destName);
            }
            case Queue: {
                return session.createQueue(destName);
            }
            case Topic: {
                return session.createTopic(destName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination lookupDestinationFromJNDI(String destName) throws Exception {
        InitialContext ic = null;
        try {
            ic = this.getDestinationJndiProperties() != null ? new InitialContext(this.getDestinationJndiProperties()) : (this.getJndiProperties() != null ? new InitialContext(this.getJndiProperties()) : new InitialContext());
            Destination destination = (Destination)ic.lookup(destName);
            return destination;
        }
        finally {
            block8: {
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (Exception e) {
                        if (!this._logger.isDebugEnabled()) break block8;
                        this._logger.debug((Object)e);
                    }
                }
            }
        }
    }

    protected MessageType getOutputMessageTypeFromContext(Context ctx) {
        String key = "org.switchyard.component.jca.endpoint.messageType";
        if (ctx.getProperty(key) != null) {
            MessageType type = MessageType.valueOf(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Output message type is set to '" + type.toString() + "'"));
            }
            return type;
        }
        return this._defaultOutMessageType;
    }

    protected int getDeliveryModeFromContext(Context ctx, MessageProducer producer) throws Exception {
        String key = "org.switchyard.component.jca.endpoint.deliveryMode";
        if (ctx.getProperty(key) != null) {
            int deliveryMode = Integer.parseInt(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Delivery Mode is set to '" + deliveryMode + "'"));
            }
            return deliveryMode;
        }
        return producer.getDeliveryMode();
    }

    protected int getPriorityFromContext(Context ctx, MessageProducer producer) throws Exception {
        String key = "org.switchyard.component.jca.endpoint.priority";
        if (ctx.getProperty(key) != null) {
            int priority = Integer.parseInt(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Priority is set to '" + priority + "'"));
            }
            return priority;
        }
        return producer.getPriority();
    }

    protected long getTimeToLiveFromContext(Context ctx, MessageProducer producer) throws Exception {
        String key = "org.switchyard.component.jca.endpoint.timeToLive";
        if (ctx.getProperty(key) != null) {
            long ttl = Long.parseLong(ctx.getPropertyValue(key).toString());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Time to Live is set to '" + ttl + "'"));
            }
            return ttl;
        }
        return producer.getTimeToLive();
    }

    public void setConnectionFactoryJNDIName(String name) {
        this._connectionFactoryJNDIName = name;
    }

    public void setDestinationType(String type) {
        DestinationType destType = this.parseDestinationType(type);
        if (destType == null) {
            JCALogger.ROOT_LOGGER.invalidDestinationType(type, DestinationType.JNDI.toString());
            destType = DestinationType.JNDI;
        }
        this._defaultDestinationType = destType;
    }

    protected DestinationType parseDestinationType(String type) {
        DestinationType destType = null;
        if (type.equals(Queue.class.getName()) || type.equalsIgnoreCase("queue")) {
            destType = DestinationType.Queue;
        } else if (type.equals(Topic.class.getName()) || type.equalsIgnoreCase("Topic")) {
            destType = DestinationType.Topic;
        } else if (type.equalsIgnoreCase("JNDI")) {
            destType = DestinationType.JNDI;
        }
        return destType;
    }

    public void setReplyTo(String name) {
        this._defaultReplyTo = name;
    }

    public void setFaultTo(String name) {
        this._defaultFaultTo = name;
    }

    public void setUsername(String user) {
        this._userName = user;
    }

    public void setPassword(String passwd) {
        this._password = passwd;
    }

    public void setMessageType(String type) {
        this._defaultOutMessageType = MessageType.valueOf(type);
    }

    public void setJndiPropertiesFileName(String name) {
        this._jndiPropertiesFileName = name;
    }

    public Properties getJndiProperties() {
        if (this._jndiPropertiesFileName != null && this._jndiProperties == null) {
            try {
                InputStream is = Classes.getResourceAsStream((String)this._jndiPropertiesFileName);
                Properties props = new Properties();
                props.load(is);
                is.close();
                this._jndiProperties = props;
            }
            catch (Exception e) {
                JCALogger.ROOT_LOGGER.failedToLoadJndiPropertiesFile(this._jndiPropertiesFileName, e);
            }
        }
        return this._jndiProperties;
    }

    public void setDestinationJndiPropertiesFileName(String name) {
        this._destinationJndiPropertiesFileName = name;
    }

    public Properties getDestinationJndiProperties() {
        if (this._destinationJndiPropertiesFileName != null && this._destinationJndiProperties == null) {
            try {
                InputStream is = Classes.getResourceAsStream((String)this._destinationJndiPropertiesFileName);
                Properties props = new Properties();
                props.load(is);
                is.close();
                this._destinationJndiProperties = props;
            }
            catch (Exception e) {
                JCALogger.ROOT_LOGGER.failedToLoadJndiPropertiesFile(this._destinationJndiPropertiesFileName, e);
            }
        }
        return this._destinationJndiProperties;
    }

    private static enum MessageType {
        Stream,
        Map,
        Text,
        Object,
        Bytes,
        Plain;

    }

    private static enum DestinationType {
        Queue,
        Topic,
        JNDI;

    }
}

