/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.common.type.Classes;
import org.switchyard.component.remote.RemoteEndpointPublisher;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;
import org.switchyard.transform.TransformSequence;

public class SwitchYardRemotingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger _log = Logger.getLogger(SwitchYardRemotingServlet.class);
    private Serializer _serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);
    private RemoteEndpointPublisher _endpointPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServiceDomain domain = this.getDomain(request);
        if (domain == null) {
            throw new ServletException("Required 'switchyard-service' header is missing or empty");
        }
        ClassLoader loader = (ClassLoader)domain.getProperties().get("DeploymentClassloader");
        ClassLoader setTCCL = Classes.setTCCL((ClassLoader)loader);
        try {
            RemoteMessage msg = (RemoteMessage)this._serializer.deserialize((InputStream)request.getInputStream(), RemoteMessage.class);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Remote servlet received request for service " + msg.getService()));
            }
            ServiceReference service = domain.getServiceReference(msg.getService());
            SynchronousInOutHandler replyHandler = new SynchronousInOutHandler();
            Exchange ex = service.createExchange((ExchangeHandler)replyHandler);
            Message m = ex.createMessage();
            ex.getContext().setProperties(msg.getContext().getProperties());
            m.setContent(msg.getContent());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invoking service " + msg.getService()));
            }
            ex.send(m);
            if (ex.getContract().getProviderOperation().getExchangePattern().equals((Object)ExchangePattern.IN_OUT)) {
                replyHandler.waitForOut();
                RemoteMessage reply = this.createReplyMessage(ex);
                ServletOutputStream out = response.getOutputStream();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Writing reply message to HTTP response stream " + msg.getService()));
                }
                this._serializer.serialize((Object)reply, RemoteMessage.class, (OutputStream)response.getOutputStream());
                out.flush();
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No content to return for invocation of " + msg.getService()));
                }
                response.setStatus(204);
            }
        }
        finally {
            Classes.setTCCL((ClassLoader)setTCCL);
        }
    }

    private ServiceDomain getDomain(HttpServletRequest request) {
        ServiceDomain domain = null;
        String service = request.getHeader("switchyard-service");
        if (service != null) {
            domain = this._endpointPublisher.getDomain(QName.valueOf(service));
        }
        return domain;
    }

    public void setEndpointPublisher(RemoteEndpointPublisher endpointPublisher) {
        this._endpointPublisher = endpointPublisher;
    }

    private RemoteMessage createReplyMessage(Exchange exchange) {
        RemoteMessage reply = new RemoteMessage();
        this.cleanContext(exchange);
        reply.setContext(exchange.getContext()).setDomain(exchange.getProvider().getDomain().getName()).setOperation(exchange.getContract().getConsumerOperation().getName()).setService(exchange.getConsumer().getName());
        if (exchange.getMessage() != null) {
            reply.setContent(exchange.getMessage().getContent());
        }
        if (exchange.getState().equals((Object)ExchangeState.FAULT)) {
            reply.setFault(true);
        }
        return reply;
    }

    private void cleanContext(Exchange exchange) {
        Property inTransform = exchange.getContext().getProperty(TransformSequence.class.getName(), Scope.IN);
        Property outTransform = exchange.getContext().getProperty(TransformSequence.class.getName(), Scope.OUT);
        if (inTransform != null) {
            exchange.getContext().removeProperty(inTransform);
        }
        if (outTransform != null) {
            exchange.getContext().removeProperty(outTransform);
        }
    }
}

