/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.remote;

import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.component.remote.RemoteEndpointPublisher;
import org.switchyard.component.remote.config.model.RemoteBindingModel;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.remote.RemoteEndpoint;
import org.switchyard.remote.RemoteRegistry;

public class RemoteServiceEndpoint
extends BaseServiceHandler {
    private RemoteBindingModel _bindingModel;
    private RemoteEndpointPublisher _endpointPublisher;
    private ServiceDomain _domain;
    private RemoteRegistry _registry;
    private RemoteEndpoint _endpoint;

    public RemoteServiceEndpoint(RemoteBindingModel bindingModel, ServiceDomain domain, RemoteEndpointPublisher endpointPublisher, RemoteRegistry registry) {
        this._bindingModel = bindingModel;
        this._endpointPublisher = endpointPublisher;
        this._domain = domain;
        this._registry = registry;
    }

    public void start() {
        QName serviceName = this._bindingModel.getService().getQName();
        this._endpointPublisher.addService(serviceName, this._domain);
        List services = this._domain.getServices(serviceName);
        if (services.isEmpty()) {
            throw new SwitchYardException("Failed to resolve service in domain " + serviceName);
        }
        this._endpoint = RemoteEndpoint.fromService((Service)((Service)services.get(0)));
        this._endpoint.setEndpoint(this._endpointPublisher.getAddress());
        this._registry.addEndpoint(this._endpoint);
    }

    public void stop() {
        this._registry.removeEndpoint(this._endpoint);
        this._endpointPublisher.removeService(this._bindingModel.getService().getQName(), this._domain);
    }

    public RemoteEndpointPublisher getEndpointPublisher() {
        return this._endpointPublisher;
    }
}

