/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.remote.deploy;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.switchyard.component.remote.RemoteEndpointPublisher;
import org.switchyard.component.remote.RemoteServiceEndpoint;
import org.switchyard.component.remote.RemoteServiceHandler;
import org.switchyard.component.remote.config.model.RemoteBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.remote.RemoteRegistry;
import org.switchyard.remote.infinispan.InfinispanRegistry;

public class RemoteActivator
extends BaseActivator {
    private static final String CACHE_CONTAINER_ROOT = "java:jboss/infinispan/container/";
    private static final String CACHE_NAME_PROPERTY = "cache-name";
    static final String[] TYPES = new String[]{"remote"};
    private static Logger _log = Logger.getLogger(RemoteRegistry.class);
    private RemoteRegistry _registry;
    private RemoteEndpointPublisher _endpointPublisher;

    public RemoteActivator(Configuration environment) {
        super(TYPES);
        String cacheName = "cluster";
        try {
            Configuration cacheConfig = environment.getFirstChild(CACHE_NAME_PROPERTY);
            if (cacheConfig != null) {
                cacheName = cacheConfig.getValue();
            }
            EmbeddedCacheManager cm = (EmbeddedCacheManager)new InitialContext().lookup(CACHE_CONTAINER_ROOT + cacheName);
            Cache cache = cm.getCache();
            this._registry = new InfinispanRegistry(cache);
        }
        catch (NamingException nEx) {
            _log.info((Object)("Unable to resolve cache-container " + cacheName + ".  <binding.remote> will not be available for services and references."));
        }
    }

    public ServiceHandler activateBinding(QName name, BindingModel config) {
        if (this._registry == null) {
            throw new SwitchYardException("Cannot enable remote binding for " + name + ".  No distributed cache is avaialble.");
        }
        if (config.isServiceBinding()) {
            return new RemoteServiceEndpoint((RemoteBindingModel)config, super.getServiceDomain(), this._endpointPublisher, this._registry);
        }
        return new RemoteServiceHandler((RemoteBindingModel)config, this._registry);
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    public void setEndpointPublisher(RemoteEndpointPublisher endpointPublisher) {
        this._endpointPublisher = endpointPublisher;
    }

    public RemoteEndpointPublisher getEndpointPublisher() {
        return this._endpointPublisher;
    }
}

