/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy;

import java.util.List;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.resteasy.RESTEasyPublishException;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;
import org.switchyard.component.resteasy.composer.RESTEasyComposition;
import org.switchyard.component.resteasy.config.model.RESTEasyBindingModel;
import org.switchyard.component.resteasy.resource.Resource;
import org.switchyard.component.resteasy.resource.ResourcePublisherFactory;
import org.switchyard.component.resteasy.util.ClassUtil;
import org.switchyard.deploy.BaseServiceHandler;

public class InboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(InboundHandler.class);
    private final RESTEasyBindingModel _config;
    private ServiceDomain _domain;
    private ServiceReference _service;
    private Resource _resource;
    private MessageComposer<RESTEasyBindingData> _messageComposer;

    public InboundHandler(RESTEasyBindingModel config, ServiceDomain domain) {
        this._config = config;
        this._domain = domain;
    }

    public void start() throws RESTEasyPublishException {
        String[] resourceIntfs = this._config.getInterfacesAsArray();
        try {
            this._service = this._domain.getServiceReference(this._config.getServiceName());
            List<Object> instances = ClassUtil.generateSingletons(resourceIntfs, (Object)this);
            String contextPath = this._config.getContextPath();
            if (contextPath == null) {
                contextPath = "/";
            }
            this._resource = ResourcePublisherFactory.getPublisher().publish(contextPath, instances);
            this._messageComposer = RESTEasyComposition.getMessageComposer(this._config);
        }
        catch (Exception e) {
            throw new RESTEasyPublishException(e);
        }
    }

    public RESTEasyBindingData invoke(String operationName, RESTEasyBindingData restMessageRequest, boolean oneWay) {
        RESTEasyBindingData output = new RESTEasyBindingData();
        try {
            SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
            Exchange exchange = this._service.createExchange(operationName, (ExchangeHandler)inOutHandler);
            Message message = this._messageComposer.compose((BindingData)restMessageRequest, exchange, true);
            if (oneWay) {
                exchange.send(message);
            } else {
                exchange.send(message);
                exchange = inOutHandler.waitForOut();
                output = (RESTEasyBindingData)this._messageComposer.decompose(exchange, (BindingData)output);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unexpected exception handling inbound REST request", (Throwable)e);
            output.setContent(null);
        }
        return output;
    }

    public void stop() {
        this._resource.stop();
    }

    public void handleFault(Exchange exchange) {
        throw new IllegalStateException("Unexpected");
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw new IllegalStateException("Unexpected");
    }
}

