/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.common.rest.RsMethod;
import org.switchyard.component.common.rest.RsMethodUtil;
import org.switchyard.component.resteasy.RESTEasyConsumeException;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;
import org.switchyard.component.resteasy.composer.RESTEasyComposition;
import org.switchyard.component.resteasy.config.model.RESTEasyBindingModel;
import org.switchyard.deploy.BaseServiceHandler;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private final RESTEasyBindingModel _config;
    private String _baseAddress = "http://localhost:8080";
    private Map<String, RsMethod> _resourcePaths;
    private MessageComposer<RESTEasyBindingData> _messageComposer;

    public OutboundHandler(RESTEasyBindingModel config) {
        this._config = config;
    }

    public void start() throws RESTEasyConsumeException {
        String resourceIntfs = this._config.getInterfaces();
        this._resourcePaths = RsMethodUtil.parseResources((String)resourceIntfs);
        String address = this._config.getAddress();
        if (address != null) {
            this._baseAddress = address;
        }
        this._messageComposer = RESTEasyComposition.getMessageComposer(this._config);
    }

    public void stop() {
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        RsMethod restMethod = this._resourcePaths.get(exchange.getContract().getProviderOperation().toString());
        String opName = exchange.getContract().getProviderOperation().getName();
        if (restMethod == null) {
            throw new RuntimeException("Could not map " + opName + " to any RESTEasy method.");
        }
        try {
            String path = RsMethodUtil.getPath((RsMethod)restMethod, (Exchange)exchange);
            String contextPath = this._config.getContextPath();
            if (contextPath != null) {
                path = "/" + contextPath + path;
            }
            ClientRequest request = new ClientRequest(this._baseAddress + path);
            RESTEasyBindingData restRequest = (RESTEasyBindingData)this._messageComposer.decompose(exchange, (BindingData)new RESTEasyBindingData());
            Object content = restRequest.getContent();
            if (restMethod.getRequestType() != null && content != null && !restMethod.hasParam().booleanValue()) {
                StringWriter sw;
                Marshaller marshaller;
                JAXBContext jaxbContext;
                if (restMethod.getConsumes().contains(MediaType.TEXT_PLAIN_TYPE)) {
                    request.body("text/plain", content);
                } else if (restMethod.getConsumes().contains(MediaType.APPLICATION_XML_TYPE) || restMethod.getConsumes().contains(MediaType.WILDCARD_TYPE)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{restMethod.getRequestType()});
                    marshaller = jaxbContext.createMarshaller();
                    sw = new StringWriter();
                    marshaller.marshal(content, (Writer)sw);
                    request.body("application/xml", (Object)((Object)sw).toString());
                } else if (restMethod.getConsumes().contains(MediaType.TEXT_XML_TYPE)) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{restMethod.getRequestType()});
                    marshaller = jaxbContext.createMarshaller();
                    sw = new StringWriter();
                    marshaller.marshal(content, (Writer)sw);
                    request.body("text/xml", (Object)((Object)sw).toString());
                } else if (restMethod.getConsumes().contains(MediaType.APPLICATION_JSON_TYPE)) {
                    ObjectMapper mapper = new ObjectMapper();
                    StringWriter sw2 = new StringWriter();
                    mapper.writeValue((Writer)sw2, content);
                    request.body("application/json", (Object)((Object)sw2).toString());
                }
            } else if (restMethod.hasQueryParam().booleanValue()) {
                request.queryParameter(restMethod.getParamName(), content);
            } else if (restMethod.hasPathParam().booleanValue()) {
                request.pathParameters(new Object[]{content});
            } else if (restMethod.hasMatrixParam().booleanValue()) {
                request.matrixParameter(restMethod.getParamName(), content);
            }
            request.getHeaders().putAll(restRequest.getHeaders());
            ClientResponse response = request.httpMethod(restMethod.getMethod(), restMethod.getResponseType());
            if (response.getStatus() == 200) {
                RESTEasyBindingData restResponse = new RESTEasyBindingData();
                restResponse.setContent(response.getEntity());
                restResponse.setHeaders((Map<String, List<String>>)response.getHeaders());
                Message out = this._messageComposer.compose((BindingData)restResponse, exchange, true);
                exchange.send(out);
            }
        }
        catch (Exception e) {
            String m = "Unexpected exception handling outbound REST request";
            LOGGER.error((Object)"Unexpected exception handling outbound REST request", (Throwable)e);
            throw new HandlerException("Unexpected exception handling outbound REST request", (Throwable)e);
        }
    }
}

