/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.composer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;

public class RESTEasyContextMapper
extends BaseRegexContextMapper<RESTEasyBindingData> {
    public void mapFrom(RESTEasyBindingData source, Context context) throws Exception {
        for (Map.Entry<String, List<String>> entry : source.getHeaders().entrySet()) {
            String name = entry.getKey();
            if (!this.matches(name)) continue;
            List<String> values = entry.getValue();
            if (values != null && values.size() == 1) {
                context.setProperty(name, (Object)values.get(0), Scope.IN).addLabels(new String[]{"jaxrs_http_header"});
                continue;
            }
            if (values == null || values.size() <= 1) continue;
            context.setProperty(name, values, Scope.IN).addLabels(new String[]{"jaxrs_http_header"});
        }
    }

    public void mapTo(Context context, RESTEasyBindingData target) throws Exception {
        Map<String, List<String>> httpHeaders = target.getHeaders();
        for (Property property : context.getProperties(Scope.OUT)) {
            Object value;
            String name;
            if (!property.hasLabel("jaxrs_http_header") || !this.matches(name = property.getName()) || (value = property.getValue()) == null) continue;
            if (value instanceof List) {
                httpHeaders.put(name, (List)value);
                continue;
            }
            if (!(value instanceof String)) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add(String.valueOf(value));
            httpHeaders.put(name, list);
        }
    }
}

