/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.resource;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.resteasy.plugins.server.sun.http.HttpContextBuilder;
import org.switchyard.component.resteasy.resource.Resource;
import org.switchyard.component.resteasy.resource.ResourcePublisher;
import org.switchyard.component.resteasy.resource.StandaloneResource;

public class StandaloneResourcePublisher
implements ResourcePublisher {
    private static final Logger LOGGER = Logger.getLogger(StandaloneResourcePublisher.class);
    private static HttpServer _httpServer;
    private static HttpContextBuilder _contextBuilder;

    @Override
    public Resource publish(String context, List<Object> instances) throws Exception {
        if (_contextBuilder.getPath().equals(context)) {
            block4: {
                _contextBuilder.cleanup();
                try {
                    _httpServer.removeContext(_contextBuilder.getPath());
                }
                catch (IllegalArgumentException iae) {
                    if (!LOGGER.isDebugEnabled()) break block4;
                    LOGGER.debug((Object)iae);
                }
            }
            _contextBuilder.getDeployment().getDefaultContextObjects().clear();
            _contextBuilder.setPath(context);
        }
        for (Object instance : instances) {
            _contextBuilder.getDeployment().getResources().add(instance);
        }
        _contextBuilder.bind(_httpServer);
        return new StandaloneResource();
    }

    static {
        try {
            _contextBuilder = new HttpContextBuilder();
            _httpServer = HttpServer.create(new InetSocketAddress(8080), 10);
            _httpServer.setExecutor(null);
            _httpServer.start();
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"Unable to launch standalone http server", (Throwable)ioe);
        }
    }
}

