/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import org.apache.log4j.Logger;
import org.switchyard.common.type.Classes;

public final class ClassUtil {
    private static final Logger LOGGER = Logger.getLogger(ClassUtil.class);
    private static final String SUFFIX = "RestImpl";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String CONTEXT_ANNOTATION = "javax.ws.rs.core.Context";
    private static final String END_OF_LINE = ";";
    private static final String FIELD_NAME = "_serviceConsumer";
    private static final String FIELD_DECL = "public org.switchyard.component.resteasy.InboundHandler _serviceConsumer;";
    private static final String FIELD_HEADERS_NAME = "_headers";
    private static final String FIELD_DECL_HEADERS = "private javax.ws.rs.core.HttpHeaders _headers;";
    private static final String METHOD_BODY_BINDING_DATA = "org.switchyard.component.resteasy.composer.RESTEasyBindingData";
    private static final String METHOD_VAR_REQUEST = "request";
    private static final String METHOD_VAR_RESPONSE = "response";
    private static final String METHOD_BODY_REQUEST = "org.switchyard.component.resteasy.composer.RESTEasyBindingData request = new org.switchyard.component.resteasy.composer.RESTEasyBindingData();";
    private static final String METHOD_BODY_HEADERS = "if (_headers != null) { request.setHeaders(_headers.getRequestHeaders());}";
    private static final String METHOD_BODY_CONTENT = "request.setContent(%s);";
    private static final String METHOD_BODY = "{%s}";
    private static final String METHOD_FRAGMENT = "_serviceConsumer.invoke(\"%s\", request";
    private static final String METHOD_WITH_NO_RETURN = "_serviceConsumer.invoke(\"%s\", request, %b);";
    private static final String METHOD_WITH_RETURN = "org.switchyard.component.resteasy.composer.RESTEasyBindingData response = _serviceConsumer.invoke(\"%s\", request, %b);";
    private static final String METHOD_RETURN = "if (response != null) { return (%s)response.getContent();}else { return null;}";

    private ClassUtil() {
    }

    public static List<Object> generateSingletons(String[] resourceIntfs, Object handler) throws Exception {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (String resourceIntf : resourceIntfs) {
            Class<?> clazz = ClassUtil.generateClass(resourceIntf);
            Object instance = clazz.newInstance();
            Field field = clazz.getField(FIELD_NAME);
            field.set(instance, handler);
            instances.add(instance);
        }
        return instances;
    }

    private static Class<?> generateClass(String resourceIntf) throws Exception {
        Class resourceClazz = Classes.forName((String)resourceIntf);
        String implClass = resourceIntf + SUFFIX;
        Class clazz = Classes.forName((String)implClass);
        if (clazz == null) {
            CtMethod[] intfMethods;
            CtClass cc;
            CtClass intf;
            ClassPool pool;
            block13: {
                pool = ClassPool.getDefault();
                pool.insertClassPath((ClassPath)new ClassClassPath(resourceClazz));
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.debug((Object)("Creating implementation class for " + resourceIntf));
                }
                intf = pool.get(resourceIntf);
                cc = null;
                try {
                    cc = pool.get(implClass);
                    if (cc != null && cc.isFrozen()) {
                        cc.defrost();
                        cc.detach();
                    }
                }
                catch (NotFoundException nfe) {
                    if (!LOGGER.isTraceEnabled()) break block13;
                    LOGGER.trace((Object)nfe);
                }
            }
            cc = pool.makeClass(implClass);
            if (intf.isInterface()) {
                cc.setInterfaces(new CtClass[]{intf});
            } else {
                cc.setSuperclass(intf);
            }
            CtField ctField = CtField.make((String)FIELD_DECL, (CtClass)cc);
            cc.addField(ctField);
            ctField = CtField.make((String)FIELD_DECL_HEADERS, (CtClass)cc);
            ConstPool cp = cc.getClassFile().getConstPool();
            AnnotationsAttribute attr = new AnnotationsAttribute(cp, "RuntimeVisibleAnnotations");
            Annotation annot = new Annotation(CONTEXT_ANNOTATION, cp);
            attr.addAnnotation(annot);
            ctField.getFieldInfo().addAttribute((AttributeInfo)attr);
            cc.addField(ctField);
            for (CtMethod intfMethod : intfMethods = intf.getDeclaredMethods()) {
                CtMethod method = CtNewMethod.copy((CtMethod)intfMethod, (CtClass)cc, null);
                CtClass[] paramTypes = method.getParameterTypes();
                String bodyFragment = "";
                StringBuilder body = new StringBuilder().append(METHOD_BODY_REQUEST).append(METHOD_BODY_HEADERS);
                if (paramTypes.length == 1) {
                    body.append(String.format(METHOD_BODY_CONTENT, "$1"));
                } else {
                    body.append(String.format(METHOD_BODY_CONTENT, "null"));
                }
                CtClass returnType = method.getReturnType();
                if (returnType != CtClass.voidType) {
                    bodyFragment = String.format(METHOD_WITH_RETURN, method.getName(), false);
                    body.append(bodyFragment);
                    body.append(String.format(METHOD_RETURN, returnType.getName()));
                } else {
                    bodyFragment = String.format(METHOD_WITH_NO_RETURN, method.getName(), true);
                    body.append(bodyFragment);
                }
                method.setBody(String.format(METHOD_BODY, body.toString()));
                cc.addMethod(method);
            }
            clazz = cc.toClass();
            if (LOGGER.isTraceEnabled()) {
                cc.writeFile(TEMP_DIR);
            }
        }
        return clazz;
    }
}

