/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.composer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.common.label.ComponentLabel;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;

public class RESTEasyContextMapper
extends BaseRegexContextMapper<RESTEasyBindingData> {
    private static final String[] RESTEASY_LABELS = new String[]{ComponentLabel.RESTEASY.label(), EndpointLabel.REST.label(), EndpointLabel.HTTP.label()};

    public void mapFrom(RESTEasyBindingData source, Context context) throws Exception {
        for (Map.Entry entry : source.getHeaders().entrySet()) {
            String name = (String)entry.getKey();
            if (!this.matches(name)) continue;
            List values = (List)entry.getValue();
            if (values != null && values.size() == 1) {
                context.setProperty(name, values.get(0), Scope.IN).addLabels(RESTEASY_LABELS);
                continue;
            }
            if (values == null || values.size() <= 1) continue;
            context.setProperty(name, (Object)values, Scope.IN).addLabels(RESTEASY_LABELS);
        }
    }

    public void mapTo(Context context, RESTEasyBindingData target) throws Exception {
        MultivaluedMap<String, String> httpHeaders = target.getHeaders();
        for (Property property : context.getProperties(Scope.OUT)) {
            Object value;
            String name;
            if (!property.hasLabel(EndpointLabel.HTTP.label()) || !this.matches(name = property.getName()) || (value = property.getValue()) == null) continue;
            if (value instanceof List) {
                httpHeaders.put(name, (String)((Object)((List)value)));
                continue;
            }
            if (!(value instanceof String)) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add(String.valueOf(value));
            httpHeaders.put(name, (String)((Object)list));
        }
    }
}

