/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.switchyard.component.resteasy.InboundHandler;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;

public final class RESTEasyProxy
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(RESTEasyProxy.class);
    private InboundHandler _serviceConsumer;

    public static Object newInstance(InboundHandler serviceConsumer, Class<?> interfaze) {
        return Proxy.newProxyInstance(interfaze.getClassLoader(), new Class[]{interfaze}, (InvocationHandler)new RESTEasyProxy(serviceConsumer));
    }

    private RESTEasyProxy(InboundHandler serviceConsumer) {
        this._serviceConsumer = serviceConsumer;
    }

    public void setConsumer(InboundHandler serviceConsumer) {
        this._serviceConsumer = serviceConsumer;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            return this.toString();
        }
        if (methodName.equals("equals")) {
            return this.equals(proxy);
        }
        if (methodName.equals("hashCode")) {
            return this.hashCode();
        }
        RESTEasyBindingData requestData = new RESTEasyBindingData();
        HttpHeaders headers = (HttpHeaders)ResteasyProviderFactory.getContextData(HttpHeaders.class);
        if (headers != null) {
            requestData.setHeaders((MultivaluedMap<String, String>)headers.getRequestHeaders());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)"Incoming Headers to SwitchYard through InboundHandler [");
                for (Map.Entry entry : headers.getRequestHeaders().entrySet()) {
                    LOGGER.trace((Object)((String)entry.getKey() + " = " + entry.getValue()));
                }
                LOGGER.trace((Object)"]");
            }
        }
        requestData.setOperationName(methodName);
        if (args != null && args.length > 0) {
            requestData.setParameters(args);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)args);
            }
        }
        RESTEasyBindingData responseData = this._serviceConsumer.invoke(requestData, method.getReturnType().equals(Void.TYPE));
        if (method.getReturnType().equals(Response.class)) {
            Response.ResponseBuilder builder = Response.ok();
            if (responseData != null) {
                builder.entity(responseData.getParameters()[0]);
                for (Map.Entry entry : responseData.getHeaders().entrySet()) {
                    builder.header((String)entry.getKey(), entry.getValue());
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)"Outgoing Headers from SwitchYard through InboundHandler [");
                    for (Map.Entry entry : responseData.getHeaders().entrySet()) {
                        LOGGER.trace((Object)((String)entry.getKey() + " = " + entry.getValue()));
                    }
                    LOGGER.trace((Object)"]");
                }
            }
            return builder.build();
        }
        if (responseData != null && responseData.getParameters().length > 0) {
            return responseData.getParameters()[0];
        }
        return null;
    }
}

