/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.resteasy.RESTEasyConsumeException;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;
import org.switchyard.component.resteasy.composer.RESTEasyComposition;
import org.switchyard.component.resteasy.config.model.RESTEasyBindingModel;
import org.switchyard.component.resteasy.resource.ResourcePublisherFactory;
import org.switchyard.component.resteasy.util.ClientInvoker;
import org.switchyard.component.resteasy.util.MethodInvoker;
import org.switchyard.deploy.BaseServiceHandler;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private static final Class<?>[] CLASS_ARG_ARRAY = new Class[]{Class.class};
    private final RESTEasyBindingModel _config;
    private String _baseAddress = "http://localhost:8080";
    private Map<String, MethodInvoker> _methodMap = new HashMap<String, MethodInvoker>();
    private MessageComposer<RESTEasyBindingData> _messageComposer;

    public OutboundHandler(RESTEasyBindingModel config) {
        this._config = config;
    }

    public void start() throws RESTEasyConsumeException {
        String resourceIntfs = this._config.getInterfaces();
        String address = this._config.getAddress();
        if (address != null) {
            this._baseAddress = address;
        }
        String path = this._baseAddress;
        String contextPath = this._config.getContextPath();
        if (contextPath != null && !ResourcePublisherFactory.ignoreContext().booleanValue()) {
            path = path + "/" + contextPath;
        }
        StringTokenizer st = new StringTokenizer(resourceIntfs, ",");
        while (st.hasMoreTokens()) {
            String className = st.nextToken().trim();
            Class clazz = Classes.forName((String)className);
            for (Method method : clazz.getMethods()) {
                if ("as".equals(method.getName()) && Arrays.equals(method.getParameterTypes(), CLASS_ARG_ARRAY)) continue;
                this._methodMap.put(method.getName(), new ClientInvoker(path, clazz, method));
            }
        }
        this._messageComposer = RESTEasyComposition.getMessageComposer(this._config);
    }

    public void stop() {
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        String opName = exchange.getContract().getProviderOperation().getName();
        RESTEasyBindingData restRequest = null;
        try {
            restRequest = (RESTEasyBindingData)this._messageComposer.decompose(exchange, (BindingData)new RESTEasyBindingData());
        }
        catch (Exception e) {
            String m = "Unexpected exception composing outbound REST request";
            LOGGER.error((Object)"Unexpected exception composing outbound REST request", (Throwable)e);
            throw new HandlerException("Unexpected exception composing outbound REST request", (Throwable)e);
        }
        Object response = null;
        MethodInvoker methodInvoker = this._methodMap.get(opName);
        if (methodInvoker == null) {
            String m = "Unable to map " + opName + " among resources " + this._methodMap.keySet();
            throw new HandlerException(m);
        }
        try {
            RESTEasyBindingData restResponse = methodInvoker.invoke(restRequest.getParameters(), restRequest.getHeaders());
            restResponse.setOperationName(opName);
            Message out = this._messageComposer.compose((BindingData)restResponse, exchange);
            exchange.send(out);
        }
        catch (Exception e) {
            String m = "Unexpected exception composing inbound Message";
            LOGGER.error((Object)"Unexpected exception composing inbound Message", (Throwable)e);
            throw new HandlerException("Unexpected exception composing inbound Message", (Throwable)e);
        }
    }
}

