/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy;

import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.resteasy.RESTEasyPublishException;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;
import org.switchyard.component.resteasy.composer.RESTEasyComposition;
import org.switchyard.component.resteasy.config.model.RESTEasyBindingModel;
import org.switchyard.component.resteasy.resource.Resource;
import org.switchyard.component.resteasy.resource.ResourcePublisherFactory;
import org.switchyard.component.resteasy.util.ClassUtil;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.label.BehaviorLabel;

public class InboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(InboundHandler.class);
    private final RESTEasyBindingModel _config;
    private final String _gatewayName;
    private ServiceDomain _domain;
    private ServiceReference _service;
    private Resource _resource;
    private MessageComposer<RESTEasyBindingData> _messageComposer;

    public InboundHandler(RESTEasyBindingModel config, ServiceDomain domain) {
        super(domain);
        this._config = config;
        this._gatewayName = config.getName();
        this._domain = domain;
    }

    protected void doStart() throws RESTEasyPublishException {
        String[] resourceIntfs = this._config.getInterfacesAsArray();
        try {
            this._service = this._domain.getServiceReference(this._config.getServiceName());
            List<Object> instances = ClassUtil.generateSingletons(resourceIntfs, this);
            String contextPath = this._config.getContextPath();
            if (contextPath == null || ResourcePublisherFactory.ignoreContext().booleanValue()) {
                contextPath = "/";
            }
            this._resource = ResourcePublisherFactory.getPublisher().publish(contextPath, instances);
            this._messageComposer = RESTEasyComposition.getMessageComposer(this._config);
        }
        catch (Exception e) {
            throw new RESTEasyPublishException(e);
        }
    }

    public RESTEasyBindingData invoke(RESTEasyBindingData restMessageRequest, boolean oneWay) throws WebApplicationException {
        RESTEasyBindingData output = new RESTEasyBindingData();
        SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
        Exchange exchange = this._service.createExchange(restMessageRequest.getOperationName(), (ExchangeHandler)inOutHandler);
        exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._gatewayName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        Message message = null;
        try {
            message = this._messageComposer.compose((BindingData)restMessageRequest, exchange);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unexpected exception composing inbound Message", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        if (oneWay) {
            exchange.send(message);
        } else {
            exchange.send(message);
            exchange = inOutHandler.waitForOut();
            try {
                output = (RESTEasyBindingData)this._messageComposer.decompose(exchange, (BindingData)output);
            }
            catch (WebApplicationException wae) {
                throw wae;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unexpected exception composing outbound REST response", (Throwable)e);
                throw new WebApplicationException((Throwable)e);
            }
        }
        return output;
    }

    protected void doStop() {
        this._resource.stop();
    }

    public void handleFault(Exchange exchange) {
        throw new IllegalStateException("Unexpected");
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw new IllegalStateException("Unexpected");
    }
}

