/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.resource;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.resteasy.plugins.server.sun.http.HttpContextBuilder;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.resteasy.RestEasyLogger;
import org.switchyard.component.resteasy.resource.ResourcePublisher;
import org.switchyard.component.resteasy.resource.StandaloneResource;

public class StandaloneResourcePublisher
implements ResourcePublisher {
    private static final Logger LOGGER = Logger.getLogger(StandaloneResourcePublisher.class);
    private static HttpServer _httpServer;
    private static HttpContextBuilder _contextBuilder;

    @Override
    public Endpoint publish(ServiceDomain domain, String context, List<Object> instances) throws Exception {
        List<Object> resourceInstances = new ArrayList<Object>();
        String path = _contextBuilder.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.equals(context)) {
            block5: {
                _contextBuilder.cleanup();
                try {
                    _httpServer.removeContext(_contextBuilder.getPath());
                }
                catch (IllegalArgumentException iae) {
                    if (!LOGGER.isDebugEnabled()) break block5;
                    LOGGER.debug((Object)iae);
                }
            }
            resourceInstances = _contextBuilder.getDeployment().getResources();
            _contextBuilder.getDeployment().getDefaultContextObjects().clear();
        }
        for (Object instance : instances) {
            resourceInstances.add(instance);
        }
        _contextBuilder.getDeployment().setResources(resourceInstances);
        _contextBuilder.setPath(context);
        _contextBuilder.bind(_httpServer);
        return new StandaloneResource();
    }

    static int getPort() {
        return Integer.getInteger("org.switchyard.component.resteasy.standalone.port", 8080);
    }

    static {
        try {
            _contextBuilder = new HttpContextBuilder();
            _httpServer = HttpServer.create(new InetSocketAddress(StandaloneResourcePublisher.getPort()), 10);
            _httpServer.setExecutor(null);
            _httpServer.start();
        }
        catch (IOException ioe) {
            RestEasyLogger.ROOT_LOGGER.unableToLaunchStandaloneHttpServer(ioe);
        }
    }
}

