/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.composer;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.composer.SecurityBindingData;
import org.switchyard.security.SecurityServices;
import org.switchyard.security.credential.ConfidentialityCredential;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.PrincipalCredential;
import org.switchyard.security.credential.extractor.AuthorizationHeaderCredentialExtractor;

public class RESTEasyBindingData
implements SecurityBindingData {
    private Object[] _args = new Object[0];
    private MultivaluedMap<String, String> _headers;
    private String _operationName;
    private Integer _statusCode;
    private ServletRequest _servletRequest;
    private Boolean _secured = false;
    private Principal _principal;

    public RESTEasyBindingData() {
    }

    public RESTEasyBindingData(Object content) {
        this._args = new Object[]{content};
    }

    public String getOperationName() {
        return this._operationName;
    }

    public void setOperationName(String operationName) {
        this._operationName = operationName;
    }

    public Object[] getParameters() {
        return this._args;
    }

    public void setParameters(Object[] args) {
        if (args != null) {
            this._args = args;
        }
    }

    public MultivaluedMap<String, String> getHeaders() {
        if (this._headers == null) {
            this._headers = new CaseInsensitiveMap();
        }
        return this._headers;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this._headers = headers;
    }

    public void addHeader(String name, List<String> values) {
        if (this._headers == null) {
            this._headers = new CaseInsensitiveMap();
        }
        this._headers.put((Object)name, values);
    }

    public void addHeader(String name, String value) {
        ArrayList<String> values;
        if (this._headers == null) {
            this._headers = new CaseInsensitiveMap();
        }
        if ((values = (ArrayList<String>)this._headers.get((Object)name)) == null) {
            values = new ArrayList<String>();
            this._headers.put((Object)name, values);
        }
        values.add(value);
    }

    public Integer getStatusCode() {
        return this._statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this._statusCode = statusCode;
    }

    public ServletRequest getServletRequest() {
        return this._servletRequest;
    }

    public void setServletRequest(ServletRequest servletRequest) {
        this._servletRequest = servletRequest;
    }

    public Boolean isSecured() {
        return this._secured;
    }

    public void setSecured(Boolean secured) {
        this._secured = secured;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public void setPrincipal(Principal principal) {
        this._principal = principal;
    }

    public Set<Credential> extractCredentials() {
        HashSet<Credential> credentials = new HashSet<Credential>();
        if (this._servletRequest != null) {
            credentials.addAll(SecurityServices.getServletRequestCredentialExtractor().extract((Object)this._servletRequest));
        } else {
            List authorizations;
            int pos;
            if (this._secured.booleanValue()) {
                credentials.add((Credential)new ConfidentialityCredential(true));
            }
            if (this._principal != null) {
                credentials.add((Credential)new PrincipalCredential(this._principal, true));
            }
            String charsetName = null;
            List contentTypes = (List)this._headers.get((Object)"content-type");
            String contentType = null;
            if (contentTypes != null && contentTypes.size() > 0) {
                contentType = (String)contentTypes.get(0);
            }
            if (contentType != null && (pos = contentType.lastIndexOf("charset=")) > -1) {
                charsetName = Strings.trimToNull((String)contentType.substring(pos + 8, contentType.length()));
            }
            if ((authorizations = (List)this._headers.get((Object)"authorization")) != null && authorizations.size() > 0) {
                AuthorizationHeaderCredentialExtractor ahce = charsetName != null ? new AuthorizationHeaderCredentialExtractor(charsetName) : new AuthorizationHeaderCredentialExtractor();
                credentials.addAll(ahce.extract((String)authorizations.get(0)));
            }
        }
        return credentials;
    }
}

