/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.resteasy.resource.NettyJaxrsServer;
import org.switchyard.component.resteasy.resource.ResourcePublisher;
import org.switchyard.component.resteasy.resource.StandaloneResource;
import org.switchyard.component.resteasy.util.RESTEasyUtil;

public class NettyResourcePublisher
implements ResourcePublisher {
    private static final Logger LOGGER = Logger.getLogger(NettyResourcePublisher.class);
    private static NettyJaxrsServer _nettyServer;

    @Override
    public Endpoint publish(ServiceDomain domain, String context, final List<Object> instances, Map<String, String> contextParams) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Publishing StandaloneResource: resouces=" + instances + ", contextParams=" + contextParams));
        }
        _nettyServer.stop();
        for (Object instance : instances) {
            _nettyServer.getDeployment().getResources().add(instance);
        }
        final List<String> providers = RESTEasyUtil.getParamValues(contextParams, "resteasy.providers");
        _nettyServer.getDeployment().getScannedProviderClasses().addAll(providers != null ? providers : Collections.emptyList());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Published StandaloneResource - Restarting Netty JAXRS Server: resources=" + instances + ", providers=" + providers));
        }
        _nettyServer.start();
        return new StandaloneResource(new StandaloneResource.Callback(){

            @Override
            public void onStart() {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Starting StandaloneResource: resources=" + instances + ", providers=" + providers));
                }
            }

            @Override
            public void onStop() {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Stopping StandaloneResource: resouces=" + instances + ", providers=" + providers));
                }
                _nettyServer.stop();
                ArrayList resources = new ArrayList(_nettyServer.getDeployment().getResources());
                for (int i = 0; instances != null && i < instances.size(); ++i) {
                    if (instances.get(i) == null) continue;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Removing RESTEasy Resource: " + instances.get(i)));
                    }
                    resources.remove(instances.get(i));
                }
                _nettyServer.getDeployment().setResources(resources);
                ArrayList scannedProviders = new ArrayList(_nettyServer.getDeployment().getScannedProviderClasses());
                for (int i = 0; providers != null && i < providers.size(); ++i) {
                    if (providers.get(i) == null) continue;
                    scannedProviders.remove(providers.get(i));
                }
                _nettyServer.getDeployment().setScannedProviderClasses(scannedProviders);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Stopped StandaloneResource - Restarting Netty JAXRS Server: resources=" + resources + ", providers=" + scannedProviders));
                }
                _nettyServer.start();
            }
        });
    }

    static {
        ResteasyDeployment deployment = new ResteasyDeployment();
        _nettyServer = new NettyJaxrsServer();
        _nettyServer.setRootResourcePath("");
        _nettyServer.setSecurityDomain(null);
        _nettyServer.setDeployment(deployment);
        _nettyServer.start();
    }
}

