/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.deploy;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.rules.config.model.RulesComponentImplementationModel;
import org.switchyard.component.rules.exchange.RulesExchangeHandler;
import org.switchyard.component.rules.exchange.RulesExchangeHandlerFactory;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.exception.SwitchYardException;

public class RulesActivator
extends BaseActivator {
    private Map<QName, RulesExchangeHandler> _handlers = new HashMap<QName, RulesExchangeHandler>();

    public RulesActivator() {
        super(new String[]{"rules"});
    }

    public ExchangeHandler init(QName qname, Model model) {
        if (model instanceof ComponentServiceModel) {
            RulesExchangeHandler handler = RulesExchangeHandlerFactory.instance().newRulesExchangeHandler();
            RulesComponentImplementationModel rciModel = (RulesComponentImplementationModel)((ComponentServiceModel)model).getComponent().getImplementation();
            handler.init(qname, rciModel);
            this._handlers.put(qname, handler);
            return handler;
        }
        throw new SwitchYardException("No Rules component implementations found for service " + qname);
    }

    public void start(ServiceReference serviceRef) {
        RulesExchangeHandler handler = this._handlers.get(serviceRef.getName());
        if (handler != null) {
            handler.start(serviceRef);
        }
    }

    public void stop(ServiceReference serviceRef) {
        RulesExchangeHandler handler = this._handlers.get(serviceRef.getName());
        if (handler != null) {
            handler.stop(serviceRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(ServiceReference serviceRef) {
        RulesExchangeHandler handler = this._handlers.get(serviceRef.getName());
        if (handler != null) {
            try {
                handler.destroy(serviceRef);
            }
            finally {
                this._handlers.remove(serviceRef.getName());
            }
        }
    }
}

