/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.Agenda;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.ScheduledAgendaItem;
import org.drools.runtime.Calendars;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.Trigger;

final class Scheduler {
    private Scheduler() {
    }

    public static void scheduleAgendaItem(ScheduledAgendaItem item, InternalAgenda agenda, InternalWorkingMemory wm) {
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = wm.getCalendars();
        Trigger trigger = item.getRule().getTimer().createTrigger(((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().getCurrentTime(), calendarNames, calendars);
        ActivationTimerJob job = new ActivationTimerJob();
        ActivationTimerJobContext ctx = new ActivationTimerJobContext(trigger, item, agenda);
        JobHandle jobHandle = ((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().scheduleJob(job, ctx, trigger);
        item.setJobHandle(jobHandle);
    }

    public static void removeAgendaItem(ScheduledAgendaItem item, InternalAgenda agenda) {
        ((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().removeJob(item.getJobHandle());
    }

    public static class ActivationTimerJobContext
    implements JobContext {
        private JobHandle jobHandle;
        private ScheduledAgendaItem scheduledAgendaItem;
        private Agenda agenda;
        private Trigger trigger;

        public ActivationTimerJobContext(Trigger trigger, ScheduledAgendaItem scheduledAgendaItem, Agenda agenda) {
            this.trigger = trigger;
            this.scheduledAgendaItem = scheduledAgendaItem;
            this.agenda = agenda;
        }

        public Agenda getAgenda() {
            return this.agenda;
        }

        public ScheduledAgendaItem getScheduledAgendaItem() {
            return this.scheduledAgendaItem;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }
    }

    public static class ActivationTimerJob
    implements Job {
        public void execute(JobContext ctx) {
            InternalAgenda agenda = (InternalAgenda)((ActivationTimerJobContext)ctx).getAgenda();
            ScheduledAgendaItem item = ((ActivationTimerJobContext)ctx).getScheduledAgendaItem();
            agenda.fireActivation(item);
            if (((ActivationTimerJobContext)ctx).getTrigger().hasNextFireTime() == null) {
                agenda.getScheduledActivationsLinkedList().remove(item);
            } else {
                item.setActivated(true);
            }
            agenda.getWorkingMemory().fireAllRules();
        }
    }
}

