/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.base.DroolsQuery;
import org.drools.base.InternalViewChangedEventListener;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.QueryElementFactHandle;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.QueryElement;
import org.drools.rule.Rule;
import org.drools.spi.PropagationContext;

public class QueryElementNode
extends LeftTupleSource
implements LeftTupleSinkNode {
    private LeftTupleSource tupleSource;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private QueryElement queryElement;
    private boolean tupleMemoryEnabled;
    private boolean openQuery;

    public QueryElementNode() {
    }

    public QueryElementNode(int id, LeftTupleSource tupleSource, QueryElement queryElement, boolean tupleMemoryEnabled, boolean openQuery, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = tupleSource;
        this.queryElement = queryElement;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.openQuery = openQuery;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.queryElement = (QueryElement)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.openQuery = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.queryElement);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeBoolean(this.openQuery);
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    public short getType() {
        return 11;
    }

    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public QueryElement getQueryElement() {
        return this.queryElement;
    }

    public boolean isOpenQuery() {
        return this.openQuery;
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object[] argTemplate = this.queryElement.getArgTemplate();
        Object[] args = new Object[argTemplate.length];
        System.arraycopy(argTemplate, 0, args, 0, args.length);
        int[] declIndexes = this.queryElement.getDeclIndexes();
        List<Integer> srcVarIndexes = null;
        int length = declIndexes.length;
        for (int i = 0; i < length; ++i) {
            Object o;
            Declaration declr = (Declaration)argTemplate[declIndexes[i]];
            Object tupleObject = leftTuple.get(declr).getObject();
            args[declIndexes[i]] = o = declr.getValue(workingMemory, tupleObject);
        }
        int[] varIndexes = this.queryElement.getVariableIndexes();
        UnificationNodeViewChangedEventListener collector = new UnificationNodeViewChangedEventListener(leftTuple, varIndexes, this, this.tupleMemoryEnabled);
        DroolsQuery queryObject = new DroolsQuery(this.queryElement.getQueryName(), args, collector, this.openQuery);
        InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(queryObject, null, workingMemory, null);
        collector.setFactHandle(handle);
        ReteooWorkingMemory.QueryInsertModifyAction action = new ReteooWorkingMemory.QueryInsertModifyAction(context, handle, leftTuple, varIndexes, srcVarIndexes, this);
        context.getQueue1().addFirst(action);
        leftTuple.setObject(handle);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ReteooWorkingMemory.QueryRetractAction action = new ReteooWorkingMemory.QueryRetractAction(context, leftTuple, this);
        context.getQueue1().addFirst(action);
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (!this.openQuery) {
            if (leftTuple.getFirstChild() != null) {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
            this.assertLeftTuple(leftTuple, context, workingMemory);
            return;
        }
        Object[] argTemplate = this.queryElement.getArgTemplate();
        Object[] args = new Object[argTemplate.length];
        System.arraycopy(argTemplate, 0, args, 0, args.length);
        int[] declIndexes = this.queryElement.getDeclIndexes();
        List<Integer> srcVarIndexes = null;
        int length = declIndexes.length;
        for (int i = 0; i < length; ++i) {
            Object o;
            Declaration declr = (Declaration)argTemplate[declIndexes[i]];
            Object tupleObject = leftTuple.get(declr).getObject();
            args[declIndexes[i]] = o = declr.getValue(workingMemory, tupleObject);
        }
        int[] varIndexes = this.queryElement.getVariableIndexes();
        InternalFactHandle handle = (InternalFactHandle)leftTuple.getObject();
        DroolsQuery queryObject = (DroolsQuery)handle.getObject();
        queryObject.setParameters(args);
        ((UnificationNodeViewChangedEventListener)queryObject.getQueryResultCollector()).setVariables(varIndexes);
        ReteooWorkingMemory.QueryInsertModifyAction action = new ReteooWorkingMemory.QueryInsertModifyAction(context, handle, leftTuple, varIndexes, srcVarIndexes, this);
        context.getQueue1().addFirst(action);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple leftTuple = modifyPreviousTuples.removeLeftTuple(this);
        if (leftTuple != null) {
            leftTuple.reAdd();
            this.modifyLeftTuple(leftTuple, context, workingMemory);
        } else {
            this.assertLeftTuple(new LeftTupleImpl(factHandle, (LeftTupleSink)this, true), context, workingMemory);
        }
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnificationNodeViewChangedEventListener
    implements InternalViewChangedEventListener {
        private LeftTuple leftTuple;
        private QueryElementNode node;
        private InternalFactHandle factHandle;
        private int[] variables;
        private boolean tupleMemoryEnabled;

        public UnificationNodeViewChangedEventListener(LeftTuple leftTuple, int[] variables, QueryElementNode node, boolean tupleMemoryEnabled) {
            this.leftTuple = leftTuple;
            this.variables = variables;
            this.node = node;
            this.tupleMemoryEnabled = tupleMemoryEnabled;
        }

        public InternalFactHandle getFactHandle() {
            return this.factHandle;
        }

        public void setFactHandle(InternalFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        public void setVariables(int[] variables) {
            this.variables = variables;
        }

        @Override
        public void rowAdded(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            QueryTerminalNode node = (QueryTerminalNode)resultLeftTuple.getLeftTupleSink();
            Declaration[] decls = node.getDeclarations();
            DroolsQuery query = (DroolsQuery)this.factHandle.getObject();
            Object[] objects = new Object[query.getElements().length];
            int length = this.variables.length;
            for (int i = 0; i < length; ++i) {
                Declaration decl = decls[this.variables[i]];
                objects[this.variables[i]] = decl.getValue(workingMemory, resultLeftTuple.get(decl).getObject());
            }
            QueryElementFactHandle resultHandle = new QueryElementFactHandle(objects, workingMemory.getFactHandleFactory().getAtomicId().incrementAndGet(), workingMemory.getFactHandleFactory().getAtomicRecency().incrementAndGet());
            RightTuple rightTuple = new RightTuple(resultHandle);
            if (query.isOpen()) {
                rightTuple.setLeftTuple(resultLeftTuple);
                resultLeftTuple.setBlocker(rightTuple);
            }
            this.node.getSinkPropagator().createChildLeftTuplesforQuery(this.leftTuple, rightTuple, true, query.isOpen());
            RightTupleList rightTuples = query.getRightTupleList();
            if (rightTuples == null) {
                rightTuples = new RightTupleList();
                query.setRightTupleList(rightTuples);
                ReteooWorkingMemory.QueryEvaluationAction evalAction = new ReteooWorkingMemory.QueryEvaluationAction(context, this.factHandle, this.leftTuple, this.node);
                context.getQueue2().addFirst(evalAction);
            }
            rightTuples.add(rightTuple);
        }

        @Override
        public void rowRemoved(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            RightTuple rightTuple = resultLeftTuple.getBlocker();
            rightTuple.setLeftTuple(null);
            resultLeftTuple.setBlocker(null);
            DroolsQuery query = (DroolsQuery)this.factHandle.getObject();
            RightTupleList rightTuples = query.getRightTupleList();
            if (rightTuples == null) {
                rightTuples = new RightTupleList();
                query.setRightTupleList(rightTuples);
                ReteooWorkingMemory.QueryResultRetractAction retractAction = new ReteooWorkingMemory.QueryResultRetractAction(context, this.factHandle, this.leftTuple, this.node);
                context.getQueue2().addFirst(retractAction);
            }
            rightTuples.add(rightTuple);
        }

        @Override
        public void rowUpdated(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            RightTuple rightTuple = resultLeftTuple.getBlocker();
            rightTuple.setLeftTuple(null);
            resultLeftTuple.setBlocker(null);
            QueryTerminalNode node = (QueryTerminalNode)resultLeftTuple.getLeftTupleSink();
            Declaration[] decls = node.getDeclarations();
            InternalFactHandle rootHandle = resultLeftTuple.get(0);
            DroolsQuery query = (DroolsQuery)rootHandle.getObject();
            Object[] objects = new Object[query.getElements().length];
            int length = this.variables.length;
            for (int i = 0; i < length; ++i) {
                Declaration decl = decls[this.variables[i]];
                objects[this.variables[i]] = decl.getValue(workingMemory, resultLeftTuple.get(decl).getObject());
            }
            QueryElementFactHandle handle = (QueryElementFactHandle)rightTuple.getFactHandle();
            handle.setRecency(workingMemory.getFactHandleFactory().getAtomicRecency().incrementAndGet());
            handle.setObject(objects);
            if (query.isOpen()) {
                rightTuple.setLeftTuple(resultLeftTuple);
                resultLeftTuple.setBlocker(rightTuple);
            }
            this.node.getSinkPropagator().createChildLeftTuplesforQuery(this.leftTuple, rightTuple, true, query.isOpen());
            RightTupleList rightTuples = query.getRightTupleList();
            if (rightTuples == null) {
                rightTuples = new RightTupleList();
                query.setRightTupleList(rightTuples);
                ReteooWorkingMemory.QueryResultUpdateAction updateAction = new ReteooWorkingMemory.QueryResultUpdateAction(context, this.factHandle, this.leftTuple, this.node);
                context.getQueue2().addFirst(updateAction);
            }
            rightTuples.add(rightTuple);
        }

        @Override
        public List<? extends Object> getResults() {
            throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support the getResults() method.");
        }
    }
}

