/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.RightTuple;
import org.drools.rule.Behavior;

public class SlidingLengthWindow
implements Externalizable,
Behavior {
    private int size;

    public SlidingLengthWindow() {
        this(0);
    }

    public SlidingLengthWindow(int size) {
        this.size = size;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
    }

    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.LENGTH_WINDOW;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Object createContext() {
        return new SlidingLengthWindowContext(this.size);
    }

    public boolean assertRightTuple(Object context, RightTuple rightTuple, InternalWorkingMemory workingMemory) {
        SlidingLengthWindowContext window = (SlidingLengthWindowContext)context;
        window.pos = (window.pos + 1) % window.rightTuples.length;
        if (window.rightTuples[window.pos] != null) {
            RightTuple tuple = window.rightTuples[window.pos];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 5, null, null, tuple.getFactHandle());
            tuple.getRightTupleSink().retractRightTuple(tuple, propagationContext, workingMemory);
            tuple.unlinkFromRightParent();
        }
        window.rightTuples[window.pos] = rightTuple;
        return true;
    }

    public void retractRightTuple(Object context, RightTuple rightTuple, InternalWorkingMemory workingMemory) {
        SlidingLengthWindowContext window = (SlidingLengthWindowContext)context;
        int last = window.pos == 0 ? window.rightTuples.length - 1 : window.pos - 1;
        int i = window.pos;
        while (i != last) {
            if (window.rightTuples[i] == rightTuple) {
                window.rightTuples[i] = null;
                break;
            }
            i = (i + 1) % window.rightTuples.length;
        }
    }

    public void expireTuples(Object context, InternalWorkingMemory workingMemory) {
    }

    public long getExpirationOffset() {
        return -1L;
    }

    public String toString() {
        return "SlidingLengthWindow( size=" + this.size + " )";
    }

    private static class SlidingLengthWindowContext
    implements Externalizable {
        public RightTuple[] rightTuples;
        public int pos = 0;

        public SlidingLengthWindowContext(int size) {
            this.rightTuples = new RightTuple[size];
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.pos = in.readInt();
            this.rightTuples = (RightTuple[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.pos);
            out.writeObject(this.rightTuples);
        }
    }
}

