/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.exchange.drools;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.drools.KnowledgeBase;
import org.drools.agent.KnowledgeAgent;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.runtime.Channel;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.rules.config.model.AuditModel;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;
import org.switchyard.component.common.rules.util.drools.Agents;
import org.switchyard.component.common.rules.util.drools.Audits;
import org.switchyard.component.common.rules.util.drools.Bases;
import org.switchyard.component.common.rules.util.drools.Configs;
import org.switchyard.component.rules.common.RulesActionType;
import org.switchyard.component.rules.config.model.ChannelModel;
import org.switchyard.component.rules.config.model.RulesActionModel;
import org.switchyard.component.rules.config.model.RulesComponentImplementationModel;
import org.switchyard.component.rules.event.drools.SwitchYardChannel;
import org.switchyard.component.rules.event.drools.SwitchYardServiceChannel;
import org.switchyard.component.rules.exchange.BaseRulesExchangeHandler;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceOperation;

public class DroolsRulesExchangeHandler
extends BaseRulesExchangeHandler {
    private static final Logger LOGGER = Logger.getLogger(DroolsRulesExchangeHandler.class);
    private final Lock _fireLock = new ReentrantLock();
    private final Lock _stateLock = new ReentrantLock();
    private String _targetNamespace;
    private String _messageContentName;
    private KnowledgeAgent _kagent;
    private AuditModel _audit;
    private Map<String, RulesActionModel> _actions = new HashMap<String, RulesActionModel>();
    private Map<String, Channel> _channels = new HashMap<String, Channel>();
    private Map<QName, ServiceReference> _references;
    private KnowledgeBase _kbase;
    private KnowledgeSessionConfiguration _ksessionConfig;
    private Environment _environment;
    private StatefulKnowledgeSession _ksession;
    private Thread _ksessionThread;
    private KnowledgeRuntimeLogger _klogger;

    @Override
    public void init(QName qname, RulesComponentImplementationModel model, Map<QName, ServiceReference> references) {
        this._targetNamespace = model.getComponent().getTargetNamespace();
        this._messageContentName = model.getMessageContentName();
        if (this._messageContentName == null) {
            this._messageContentName = "messageContent";
        }
        ClassLoader loader = Classes.getClassLoader(this.getClass());
        ResourceType.install((ClassLoader)loader);
        if (model.isAgent()) {
            this._kagent = Agents.newAgent((ComponentImplementationModel)model, (ClassLoader)loader, (Resource[])new Resource[0]);
            this._kbase = this._kagent.getKnowledgeBase();
        } else {
            this._kbase = Bases.newBase((ComponentImplementationModel)model, (ClassLoader)loader, (Resource[])new Resource[0]);
        }
        this._ksessionConfig = Configs.getSessionConfiguration((ComponentImplementationModel)model);
        this._environment = Configs.getEnvironment();
        this._audit = model.getAudit();
        for (RulesActionModel ram : model.getRulesActions()) {
            this._actions.put(ram.getName(), ram);
        }
        for (ChannelModel cm : model.getChannels()) {
            Class<SwitchYardServiceChannel> clazz = Classes.forName((String)cm.getClazz(), (ClassLoader)loader);
            if (clazz == null) {
                clazz = SwitchYardServiceChannel.class;
            }
            if (Channel.class.isAssignableFrom(clazz)) {
                Channel channel;
                Class<SwitchYardServiceChannel> channelClass = clazz;
                try {
                    channel = (Channel)channelClass.newInstance();
                }
                catch (Exception e) {
                    throw new SwitchYardException((Throwable)e);
                }
                if (channel instanceof SwitchYardChannel) {
                    ((SwitchYardChannel)channel).setModel(cm);
                }
                this._channels.put(cm.getName(), channel);
                continue;
            }
            LOGGER.warn((Object)(clazz.getName() + " does not implement " + Channel.class.getName()));
        }
        this._references = references;
    }

    @Override
    public void start(ServiceReference serviceRef) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Exchange exchange) throws HandlerException {
        if (!ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            return;
        }
        Context context = exchange.getContext();
        ServiceOperation serviceOperation = exchange.getContract().getServiceOperation();
        RulesActionModel rulesActionModel = this._actions.get(serviceOperation.getName());
        RulesActionType rulesActionType = this.getRulesActionType(context, rulesActionModel);
        Message message = exchange.getMessage();
        Object content = message.getContent();
        switch (rulesActionType) {
            case EXECUTE: {
                StatelessKnowledgeSession ksessionStateless = this.getStatelessSession();
                KnowledgeRuntimeLogger klogger = Audits.getLogger((AuditModel)this._audit, (KnowledgeRuntimeEventManager)ksessionStateless);
                try {
                    ksessionStateless.getGlobals().set("message", (Object)message);
                    ksessionStateless.execute(content);
                    message = (Message)ksessionStateless.getGlobals().get("message");
                    content = message.getContent();
                    break;
                }
                finally {
                    if (klogger != null) {
                        klogger.close();
                    }
                }
            }
            case FIRE_ALL_RULES: {
                this._fireLock.lock();
                try {
                    StatefulKnowledgeSession ksessionStateful = this.getStatefulSession();
                    ksessionStateful.getGlobals().set("message", (Object)message);
                    ksessionStateful.insert(content);
                    ksessionStateful.fireAllRules();
                    message = (Message)ksessionStateful.getGlobals().get("message");
                    content = message.getContent();
                    if (!this.isDispose(context)) break;
                    this.disposeStatefulSession();
                    break;
                }
                finally {
                    this._fireLock.unlock();
                }
            }
            case FIRE_UNTIL_HALT: {
                this._fireLock.lock();
                try {
                    boolean ksessionNew = this._ksession == null;
                    final StatefulKnowledgeSession ksessionStateful = this.getStatefulSession();
                    ksessionStateful.insert(content);
                    content = null;
                    if (ksessionNew) {
                        final ClassLoader goodClassLoader = Classes.getClassLoader(this.getClass());
                        this._ksessionThread = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Thread thread = Thread.currentThread();
                                ClassLoader origClassLoader = thread.getContextClassLoader();
                                thread.setContextClassLoader(goodClassLoader);
                                try {
                                    ksessionStateful.fireUntilHalt();
                                }
                                catch (NullPointerException ne) {
                                    ne.getMessage();
                                }
                                finally {
                                    thread.setContextClassLoader(origClassLoader);
                                }
                            }
                        });
                        this._ksessionThread.setName(this.getClass().getSimpleName() + ":fireUntilHalt(" + System.identityHashCode(ksessionStateful) + ")");
                        this._ksessionThread.setDaemon(true);
                        this._ksessionThread.start();
                    }
                    if (!this.isDispose(context)) break;
                    this.disposeStatefulSession();
                    break;
                }
                finally {
                    this._fireLock.unlock();
                }
            }
            default: {
                throw new UnsupportedOperationException("Unsupported rules action type: " + (Object)((Object)rulesActionType));
            }
        }
        ExchangePattern exchangePattern = serviceOperation.getExchangePattern();
        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
            message = exchange.createMessage();
            if (content != null) {
                message.setContent(content);
            }
            exchange.send(message);
        }
    }

    @Override
    public void stop(ServiceReference serviceRef) {
        this.disposeStatefulSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(ServiceReference serviceRef) {
        this._kbase = null;
        this._actions.clear();
        this._channels.clear();
        this._audit = null;
        this._messageContentName = null;
        if (this._kagent != null) {
            try {
                this._kagent.dispose();
            }
            finally {
                this._kagent = null;
            }
        }
    }

    private StatelessKnowledgeSession getStatelessSession() {
        StatelessKnowledgeSession ksessionStateless = this._kagent != null ? this._kagent.newStatelessKnowledgeSession(this._ksessionConfig) : this._kbase.newStatelessKnowledgeSession(this._ksessionConfig);
        return ksessionStateless;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatefulKnowledgeSession getStatefulSession() {
        this._stateLock.lock();
        try {
            if (this._ksession == null) {
                this._ksession = this._kbase.newStatefulKnowledgeSession(this._ksessionConfig, this._environment);
                this._klogger = Audits.getLogger((AuditModel)this._audit, (KnowledgeRuntimeEventManager)this._ksession);
                for (Map.Entry<String, Channel> entry : this._channels.entrySet()) {
                    String name = entry.getKey();
                    Channel channel = entry.getValue();
                    if (name == null || channel == null) continue;
                    if (channel instanceof SwitchYardChannel) {
                        SwitchYardChannel syc = (SwitchYardChannel)channel;
                        QName qname = XMLHelper.createQName((String)this._targetNamespace, (String)syc.getModel().getReference());
                        ServiceReference reference = this._references.get(qname);
                        syc.setReference(reference);
                    }
                    this._ksession.registerChannel(name, channel);
                }
            }
            StatefulKnowledgeSession statefulKnowledgeSession = this._ksession;
            return statefulKnowledgeSession;
        }
        finally {
            this._stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeStatefulSession() {
        block21: {
            this._stateLock.lock();
            try {
                if (this._ksession == null) break block21;
                try {
                    this._ksession.halt();
                }
                finally {
                    try {
                        this._ksession.dispose();
                    }
                    finally {
                        this._ksession = null;
                        if (this._klogger != null) {
                            try {
                                this._klogger.close();
                            }
                            finally {
                                this._klogger = null;
                            }
                        }
                    }
                }
            }
            finally {
                this._stateLock.unlock();
            }
        }
    }
}

