/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.config.model;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.rules.Audit;
import org.switchyard.component.common.rules.Mapping;
import org.switchyard.component.common.rules.config.model.AuditModel;
import org.switchyard.component.common.rules.config.model.MappingModel;
import org.switchyard.component.common.rules.config.model.v1.V1AuditModel;
import org.switchyard.component.common.rules.config.model.v1.V1MappingModel;
import org.switchyard.component.rules.Channel;
import org.switchyard.component.rules.Execute;
import org.switchyard.component.rules.FireAllRules;
import org.switchyard.component.rules.FireUntilHalt;
import org.switchyard.component.rules.Rules;
import org.switchyard.component.rules.RulesActionType;
import org.switchyard.component.rules.config.model.ChannelModel;
import org.switchyard.component.rules.config.model.GlobalsModel;
import org.switchyard.component.rules.config.model.RulesActionModel;
import org.switchyard.component.rules.config.model.v1.V1ChannelModel;
import org.switchyard.component.rules.config.model.v1.V1GlobalsModel;
import org.switchyard.component.rules.config.model.v1.V1RulesActionModel;
import org.switchyard.component.rules.config.model.v1.V1RulesComponentImplementationModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentReferenceModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.resource.v1.V1ResourceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.metadata.java.JavaService;

public class RulesSwitchYardScanner
implements Scanner<SwitchYardModel> {
    private static final IsAnnotationPresentFilter EXECUTE_FILTER = new IsAnnotationPresentFilter(Execute.class);
    private static final IsAnnotationPresentFilter FIRE_ALL_RULES_FILTER = new IsAnnotationPresentFilter(FireAllRules.class);
    private static final IsAnnotationPresentFilter FIRE_UNTIL_HALT_FILTER = new IsAnnotationPresentFilter(FireUntilHalt.class);
    private static final String UNDEFINED = "";
    private static final String INTERFACE_ERR_MSG = " is a class. @Rules only allowed on interfaces.";
    private final IsAnnotationPresentFilter _rulesFilter = new IsAnnotationPresentFilter(Rules.class);

    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel();
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getName());
        ClasspathScanner rulesScanner = new ClasspathScanner((Filter)this._rulesFilter);
        for (URL url : input.getURLs()) {
            rulesScanner.scan(url);
        }
        List rulesClasses = this._rulesFilter.getMatchedTypes();
        for (Class rulesClass : rulesClasses) {
            Rules rules = rulesClass.getAnnotation(Rules.class);
            Class rulesInterface = rules.value();
            if (Rules.UndefinedRulesInterface.class.equals(rulesInterface)) {
                rulesInterface = rulesClass;
            }
            if (!rulesInterface.isInterface()) {
                throw new IOException(rulesInterface.getName() + INTERFACE_ERR_MSG);
            }
            String rulesName = Strings.trimToNull((String)rules.name());
            if (rulesName == null) {
                rulesName = rulesInterface.getSimpleName();
            }
            V1ComponentModel componentModel = new V1ComponentModel();
            componentModel.setName(rulesName);
            V1RulesComponentImplementationModel rciModel = new V1RulesComponentImplementationModel();
            rciModel.setAgent(rules.agent());
            rciModel.setClock(rules.clock());
            rciModel.setEventProcessing(rules.eventProcessing());
            int maxThreads = rules.maxThreads();
            if (maxThreads != -1) {
                rciModel.setMaxThreads(maxThreads);
            }
            rciModel.setMultithreadEvaluation(rules.multithreadEvaluation());
            JavaService javaService = JavaService.fromClass((Class)rulesInterface);
            for (Method method : rulesClass.getDeclaredMethods()) {
                ServiceOperation srvOper;
                RulesActionType rat = null;
                String ep = null;
                if (EXECUTE_FILTER.matches(method)) {
                    rat = RulesActionType.EXECUTE;
                } else if (FIRE_ALL_RULES_FILTER.matches(method)) {
                    rat = RulesActionType.FIRE_ALL_RULES;
                } else if (FIRE_UNTIL_HALT_FILTER.matches(method)) {
                    rat = RulesActionType.FIRE_UNTIL_HALT;
                    ep = Strings.trimToNull((String)method.getAnnotation(FireUntilHalt.class).entryPoint());
                }
                if (rat == null || (srvOper = javaService.getOperation(method.getName())) == null) continue;
                RulesActionModel ram = new V1RulesActionModel().setName(srvOper.getName()).setType(rat).setEntryPoint(ep);
                rciModel.addRulesAction(ram);
            }
            Audit audit = rulesClass.getAnnotation(Audit.class);
            if (audit != null) {
                V1AuditModel aModel = new V1AuditModel(rciModel.getModelConfiguration().getQName().getNamespaceURI());
                aModel.setType(audit.type());
                int interval = audit.interval();
                if (interval != -1) {
                    aModel.setInterval(Integer.valueOf(interval));
                }
                if (!UNDEFINED.equals(audit.log())) {
                    aModel.setLog(audit.log());
                }
                rciModel.setAudit((AuditModel)aModel);
            }
            for (Channel channel : rules.channels()) {
                Class<?> channelClass = channel.value();
                ChannelModel channelModel = new V1ChannelModel().setClazz(channelClass.getName());
                String channelName = channel.name();
                if (UNDEFINED.equals(channelName)) {
                    channelName = channelClass.getSimpleName();
                }
                channelModel.setName(channelName);
                if (!UNDEFINED.equals(channel.operation())) {
                    channelModel.setOperation(channel.operation());
                }
                if (!UNDEFINED.equals(channel.input())) {
                    channelModel.setInput(XMLHelper.createQName((String)channel.input()));
                }
                if (!UNDEFINED.equals(channel.reference())) {
                    String reference = channel.reference();
                    channelModel.setReference(reference);
                    V1ComponentReferenceModel compRefModel = new V1ComponentReferenceModel();
                    compRefModel.setName(reference);
                    if (!Channel.UndefinedInterface.class.equals(channel.interfaze())) {
                        V1InterfaceModel compRefIfaceModel = new V1InterfaceModel("java");
                        compRefIfaceModel.setInterface(channel.interfaze().getName());
                        compRefModel.setInterface((InterfaceModel)compRefIfaceModel);
                        componentModel.addReference((ComponentReferenceModel)compRefModel);
                    }
                }
                rciModel.addChannel(channelModel);
            }
            for (String location : rules.resources()) {
                if (UNDEFINED.equals(location)) continue;
                rciModel.addResource(new V1ResourceModel("urn:switchyard-component-rules:config:1.0").setLocation(location));
            }
            GlobalsModel globalsModel = null;
            for (Mapping globalMapping : rules.globals()) {
                V1MappingModel mappingModel = new V1MappingModel("urn:switchyard-component-rules:config:1.0");
                mappingModel.setContextScope(globalMapping.contextScope());
                mappingModel.setExpression(globalMapping.expression());
                mappingModel.setExpressionType(globalMapping.expressionType());
                String variable = globalMapping.variable();
                if (!UNDEFINED.equals(variable)) {
                    mappingModel.setVariable(variable);
                }
                if (globalsModel == null) {
                    globalsModel = new V1GlobalsModel();
                    rciModel.setGlobals(globalsModel);
                }
                globalsModel.addMapping((MappingModel)mappingModel);
            }
            componentModel.setImplementation((ComponentImplementationModel)rciModel);
            V1ComponentServiceModel serviceModel = new V1ComponentServiceModel();
            V1InterfaceModel csiModel = new V1InterfaceModel("java");
            csiModel.setInterface(rulesInterface.getName());
            serviceModel.setInterface((InterfaceModel)csiModel);
            serviceModel.setName(rulesName);
            componentModel.addService((ComponentServiceModel)serviceModel);
            compositeModel.addComponent((ComponentModel)componentModel);
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }
}

