/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.exchange.drools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import org.drools.KnowledgeBase;
import org.drools.agent.KnowledgeAgent;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.runtime.Channel;
import org.drools.runtime.Environment;
import org.drools.runtime.Globals;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.rules.config.model.AuditModel;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;
import org.switchyard.component.common.rules.config.model.MappingModel;
import org.switchyard.component.common.rules.expression.ContextMap;
import org.switchyard.component.common.rules.expression.Expression;
import org.switchyard.component.common.rules.expression.ExpressionFactory;
import org.switchyard.component.common.rules.util.drools.Agents;
import org.switchyard.component.common.rules.util.drools.Audits;
import org.switchyard.component.common.rules.util.drools.Bases;
import org.switchyard.component.common.rules.util.drools.ComponentImplementationConfig;
import org.switchyard.component.common.rules.util.drools.Configs;
import org.switchyard.component.common.rules.util.drools.Environments;
import org.switchyard.component.common.rules.util.drools.Events;
import org.switchyard.component.rules.RulesActionType;
import org.switchyard.component.rules.channel.drools.SwitchYardChannel;
import org.switchyard.component.rules.channel.drools.SwitchYardServiceChannel;
import org.switchyard.component.rules.config.model.ChannelModel;
import org.switchyard.component.rules.config.model.FactsModel;
import org.switchyard.component.rules.config.model.GlobalsModel;
import org.switchyard.component.rules.config.model.RulesActionModel;
import org.switchyard.component.rules.config.model.RulesComponentImplementationModel;
import org.switchyard.component.rules.exchange.BaseRulesExchangeHandler;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceOperation;

public class DroolsRulesExchangeHandler
extends BaseRulesExchangeHandler {
    private final Lock _fireLock = new ReentrantLock();
    private final Lock _stateLock = new ReentrantLock();
    private ComponentImplementationConfig _componentImplementationConfig;
    private String _targetNamespace;
    private ServiceDomain _domain;
    private KnowledgeAgent _kagent;
    private AuditModel _audit;
    private Map<String, RulesActionModel> _actions = new HashMap<String, RulesActionModel>();
    private Map<String, Channel> _channels = new HashMap<String, Channel>();
    private Map<String, Scope> _globalContextScopes = new HashMap<String, Scope>();
    private Map<String, Expression> _globalExpressions = new HashMap<String, Expression>();
    private boolean _useFactMappings = false;
    private Map<String, Scope> _factContextScopes = new HashMap<String, Scope>();
    private Map<String, Expression> _factExpressions = new HashMap<String, Expression>();
    private KnowledgeBase _kbase;
    private KnowledgeSessionConfiguration _ksessionConfig;
    private Environment _environment;
    private StatefulKnowledgeSession _ksession;
    private Thread _ksessionThread;
    private KnowledgeRuntimeLogger _klogger;

    @Override
    public void init(QName qname, RulesComponentImplementationModel model, ServiceDomain domain) {
        FactsModel facts;
        this._targetNamespace = model.getComponent().getTargetNamespace();
        this._domain = domain;
        ClassLoader loader = Classes.getClassLoader(this.getClass());
        ResourceType.install((ClassLoader)loader);
        this._componentImplementationConfig = new ComponentImplementationConfig((ComponentImplementationModel)model, loader);
        if (model.isAgent()) {
            this._kagent = Agents.newAgent((ComponentImplementationConfig)this._componentImplementationConfig, (Resource[])new Resource[0]);
            this._kbase = this._kagent.getKnowledgeBase();
        } else {
            this._kbase = Bases.newBase((ComponentImplementationConfig)this._componentImplementationConfig, (Resource[])new Resource[0]);
        }
        this._ksessionConfig = Configs.getSessionConfiguration((ComponentImplementationConfig)this._componentImplementationConfig);
        this._environment = Environments.getEnvironment((ComponentImplementationConfig)this._componentImplementationConfig);
        this._audit = model.getAudit();
        for (RulesActionModel ram : model.getRulesActions()) {
            this._actions.put(ram.getName(), ram);
        }
        for (ChannelModel cm : model.getChannels()) {
            Channel channel;
            Class<Object> clazz = cm.getClazz(this._componentImplementationConfig.getLoader());
            if (clazz == null) {
                clazz = SwitchYardServiceChannel.class;
            } else if (!Channel.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(Channel.class.getName() + " is not assignable from " + clazz.getName());
            }
            try {
                channel = (Channel)clazz.newInstance();
            }
            catch (Exception e) {
                throw new SwitchYardException((Throwable)e);
            }
            if (channel instanceof SwitchYardChannel) {
                ((SwitchYardChannel)channel).setModel(cm);
            }
            this._channels.put(cm.getName(), channel);
        }
        GlobalsModel globals = model.getGlobals();
        if (globals != null) {
            ExpressionFactory factory = ExpressionFactory.instance();
            for (MappingModel mapping : globals.getMappings()) {
                this._globalContextScopes.put(mapping.getVariable(), mapping.getContextScope());
                this._globalExpressions.put(mapping.getVariable(), factory.create(mapping));
            }
        }
        if ((facts = model.getFacts()) != null) {
            this._useFactMappings = true;
            ExpressionFactory factory = ExpressionFactory.instance();
            for (MappingModel mapping : facts.getMappings()) {
                this._factContextScopes.put(mapping.getVariable(), mapping.getContextScope());
                this._factExpressions.put(mapping.getVariable(), factory.create(mapping));
            }
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(Exchange exchange) throws HandlerException {
        if (!ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            return;
        }
        Context context = exchange.getContext();
        ServiceOperation serviceOperation = exchange.getContract().getProviderOperation();
        RulesActionModel rulesActionModel = this._actions.get(serviceOperation.getName());
        RulesActionType rulesActionType = this.getRulesActionType(context, rulesActionModel);
        Message message = exchange.getMessage();
        Object content = message.getContent();
        switch (rulesActionType) {
            case EXECUTE: {
                StatelessKnowledgeSession ksessionStateless = this.getStatelessSession();
                KnowledgeRuntimeLogger klogger = Audits.getLogger((AuditModel)this._audit, (KnowledgeRuntimeEventManager)ksessionStateless);
                try {
                    Globals globals = ksessionStateless.getGlobals();
                    this.setGlobals(globals, exchange, true);
                    List<Object> facts = this.getFacts(content, exchange);
                    ksessionStateless.execute(facts);
                    message = (Message)globals.get("message");
                    content = message != null ? message.getContent() : null;
                    break;
                }
                finally {
                    if (klogger != null) {
                        klogger.close();
                    }
                }
            }
            case FIRE_ALL_RULES: {
                this._fireLock.lock();
                try {
                    StatefulKnowledgeSession ksessionStateful = this.getStatefulSession();
                    Globals globals = ksessionStateful.getGlobals();
                    this.setGlobals(globals, exchange, true);
                    List<Object> facts = this.getFacts(content, exchange);
                    for (Object fact : facts) {
                        ksessionStateful.insert(fact);
                    }
                    ksessionStateful.fireAllRules();
                    message = (Message)globals.get("message");
                    Object object = content = message != null ? message.getContent() : null;
                    if (!this.isDispose(context)) break;
                    this.disposeStatefulSession();
                    break;
                }
                finally {
                    this._fireLock.unlock();
                }
            }
            case FIRE_UNTIL_HALT: {
                this._fireLock.lock();
                try {
                    boolean ksessionNew = this._ksession == null;
                    final StatefulKnowledgeSession ksessionStateful = this.getStatefulSession();
                    Globals globals = ksessionStateful.getGlobals();
                    this.setGlobals(globals, exchange, false);
                    if (ksessionNew) {
                        final ClassLoader properLoader = Classes.getClassLoader(this.getClass());
                        this._ksessionThread = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                ClassLoader originalLoader = Classes.setTCCL((ClassLoader)properLoader);
                                try {
                                    ksessionStateful.fireUntilHalt();
                                }
                                catch (NullPointerException ne) {
                                    ne.getMessage();
                                }
                                finally {
                                    Classes.setTCCL((ClassLoader)originalLoader);
                                }
                            }
                        });
                        this._ksessionThread.setName(this.getClass().getSimpleName() + ":fireUntilHalt(" + System.identityHashCode(ksessionStateful) + ")");
                        this._ksessionThread.setDaemon(true);
                        this._ksessionThread.start();
                    }
                    List<Object> facts = this.getFacts(content, exchange);
                    String ep = this.getEntryPoint(rulesActionModel);
                    if (ep != null) {
                        WorkingMemoryEntryPoint wmep = ksessionStateful.getWorkingMemoryEntryPoint(ep);
                        if (wmep == null) throw new HandlerException("Unknown entry point: " + ep + "; please check your rules source.");
                        for (Object fact : facts) {
                            wmep.insert(fact);
                        }
                    } else {
                        for (Object fact : facts) {
                            ksessionStateful.insert(fact);
                        }
                    }
                    content = null;
                    if (!this.isDispose(context)) break;
                    this.disposeStatefulSession();
                    break;
                }
                finally {
                    this._fireLock.unlock();
                }
            }
            default: {
                throw new UnsupportedOperationException("Unsupported rules action type: " + (Object)((Object)rulesActionType));
            }
        }
        ExchangePattern exchangePattern = serviceOperation.getExchangePattern();
        if (!ExchangePattern.IN_OUT.equals((Object)exchangePattern)) return;
        message = exchange.createMessage();
        if (content != null) {
            message.setContent(content);
        }
        exchange.send(message);
    }

    private void setGlobals(Globals globals, Exchange exchange, boolean includeTrifecta) {
        if (includeTrifecta) {
            globals.set("exchange", (Object)exchange);
            globals.set("context", (Object)exchange.getContext());
            globals.set("message", (Object)exchange.getMessage());
        }
        for (Map.Entry<String, Expression> entry : this._globalExpressions.entrySet()) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("exchange", exchange);
            vars.put("context", new ContextMap(exchange.getContext(), this._globalContextScopes.get(entry.getKey())));
            vars.put("message", exchange.getMessage());
            Object global = entry.getValue().evaluate(vars);
            globals.set(entry.getKey(), global);
        }
    }

    private List<Object> getFacts(Object content, Exchange exchange) {
        ArrayList<Object> facts = new ArrayList<Object>();
        if (this._useFactMappings) {
            for (Map.Entry<String, Expression> entry : this._factExpressions.entrySet()) {
                HashMap<String, Object> vars = new HashMap<String, Object>();
                vars.put("exchange", exchange);
                vars.put("context", new ContextMap(exchange.getContext(), this._factContextScopes.get(entry.getKey())));
                vars.put("message", exchange.getMessage());
                Object fact = entry.getValue().evaluate(vars);
                this.addFact(fact, facts);
            }
        } else {
            this.addFact(content, facts);
        }
        return facts;
    }

    private void addFact(Object fact, List<Object> facts) {
        if (fact != null) {
            if (fact instanceof Iterable) {
                for (Object f : (Iterable)fact) {
                    if (f == null) continue;
                    facts.add(f);
                }
            } else {
                facts.add(fact);
            }
        }
    }

    public void stop() {
        this.disposeStatefulSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this._kbase = null;
        this._actions.clear();
        this._channels.clear();
        this._audit = null;
        this._globalContextScopes.clear();
        this._globalExpressions.clear();
        this._useFactMappings = false;
        this._factContextScopes.clear();
        this._factExpressions.clear();
        if (this._kagent != null) {
            try {
                this._kagent.dispose();
            }
            finally {
                this._kagent = null;
            }
        }
        this._componentImplementationConfig = null;
    }

    private StatelessKnowledgeSession getStatelessSession() {
        StatelessKnowledgeSession ksessionStateless = this._kagent != null ? this._kagent.newStatelessKnowledgeSession(this._ksessionConfig) : this._kbase.newStatelessKnowledgeSession(this._ksessionConfig);
        Events.addEventListeners((ComponentImplementationConfig)this._componentImplementationConfig, (KnowledgeRuntimeEventManager)ksessionStateless);
        return ksessionStateless;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatefulKnowledgeSession getStatefulSession() {
        this._stateLock.lock();
        try {
            if (this._ksession == null) {
                this._ksession = this._kbase.newStatefulKnowledgeSession(this._ksessionConfig, this._environment);
                this._klogger = Audits.getLogger((AuditModel)this._audit, (KnowledgeRuntimeEventManager)this._ksession);
                Events.addEventListeners((ComponentImplementationConfig)this._componentImplementationConfig, (KnowledgeRuntimeEventManager)this._ksession);
                for (Map.Entry<String, Channel> c : this._channels.entrySet()) {
                    String name = c.getKey();
                    Channel channel = c.getValue();
                    if (name == null || channel == null) continue;
                    if (channel instanceof SwitchYardChannel) {
                        SwitchYardChannel syc = (SwitchYardChannel)channel;
                        QName qname = XMLHelper.createQName((String)this._targetNamespace, (String)syc.getModel().getReference());
                        ServiceReference reference = this._domain.getServiceReference(qname);
                        syc.setReference(reference);
                    }
                    this._ksession.registerChannel(name, channel);
                }
            }
            StatefulKnowledgeSession statefulKnowledgeSession = this._ksession;
            return statefulKnowledgeSession;
        }
        finally {
            this._stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeStatefulSession() {
        block21: {
            this._stateLock.lock();
            try {
                if (this._ksession == null) break block21;
                try {
                    this._ksession.halt();
                }
                finally {
                    try {
                        this._ksession.dispose();
                    }
                    finally {
                        this._ksession = null;
                        if (this._klogger != null) {
                            try {
                                this._klogger.close();
                            }
                            finally {
                                this._klogger = null;
                            }
                        }
                    }
                }
            }
            finally {
                this._stateLock.unlock();
            }
        }
    }
}

