/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.exchange;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.kie.runtime.rule.SessionEntryPoint;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.knowledge.ActionType;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeAction;
import org.switchyard.component.common.knowledge.exchange.KnowledgeExchangeHandler;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.util.Mappings;
import org.switchyard.component.rules.RulesActionType;
import org.switchyard.component.rules.RulesConstants;
import org.switchyard.component.rules.config.model.RulesComponentImplementationModel;

public class RulesExchangeHandler
extends KnowledgeExchangeHandler<RulesComponentImplementationModel> {
    private static final AtomicInteger FIRE_UNTIL_HALT_COUNT = new AtomicInteger();
    private static final KnowledgeAction DEFAULT_ACTION = new KnowledgeAction(null, (ActionType)RulesActionType.EXECUTE);
    private Thread _fireUntilHaltThread = null;

    public RulesExchangeHandler(RulesComponentImplementationModel model, ServiceDomain domain) {
        super((KnowledgeComponentImplementationModel)model, domain);
    }

    public KnowledgeAction getDefaultAction() {
        return DEFAULT_ACTION;
    }

    public void handleAction(Exchange exchange, KnowledgeAction action) throws HandlerException {
        RulesActionType actionType = (RulesActionType)action.getType();
        switch (actionType) {
            case EXECUTE: {
                KnowledgeSession session = this.newStatelessSession();
                Mappings.setGlobals((Exchange)exchange, (KnowledgeAction)action, (KnowledgeSession)session, (boolean)true);
                List input = Mappings.getInputList((Exchange)exchange, (KnowledgeAction)action);
                session.getStateless().execute((Iterable)input);
                break;
            }
            case INSERT: 
            case FIRE_ALL_RULES: {
                KnowledgeSession session = this.getStatefulSession();
                Mappings.setGlobals((Exchange)exchange, (KnowledgeAction)action, (KnowledgeSession)session, (boolean)true);
                List input = Mappings.getInputList((Exchange)exchange, (KnowledgeAction)action);
                for (Object fact : input) {
                    session.getStateful().insert(fact);
                }
                if (RulesActionType.FIRE_ALL_RULES.equals((Object)actionType)) {
                    session.getStateful().fireAllRules();
                }
                if (!this.isDispose(exchange)) break;
                this.disposeStatefulSession();
                break;
            }
            case FIRE_UNTIL_HALT: {
                KnowledgeSession session = this.getStatefulSession();
                Mappings.setGlobals((Exchange)exchange, (KnowledgeAction)action, (KnowledgeSession)session, (boolean)false);
                if (this._fireUntilHaltThread == null) {
                    FireUntilHalt fireUntilHalt = new FireUntilHalt(this, session, this.getLoader());
                    session.addDisposals(new KnowledgeDisposal[]{fireUntilHalt});
                    this._fireUntilHaltThread = fireUntilHalt.startThread();
                }
                String undefinedVariable = Mappings.toVariable((Object)exchange);
                Map listMap = Mappings.getListMap((Exchange)exchange, (List)action.getInputExpressionMappings(), (boolean)true, (String)undefinedVariable);
                if (listMap.size() > 0) {
                    for (Map.Entry entry : listMap.entrySet()) {
                        String id;
                        String key = (String)entry.getKey();
                        if (undefinedVariable.equals(key) && (id = Strings.trimToNull((String)action.getId())) != null) {
                            key = id;
                        }
                        List input = (List)entry.getValue();
                        if (undefinedVariable.equals(key)) {
                            for (Object fact : input) {
                                session.getStateful().insert(fact);
                            }
                            continue;
                        }
                        SessionEntryPoint sep = session.getStateful().getEntryPoint(key);
                        if (sep != null) {
                            for (Object fact : input) {
                                sep.insert(fact);
                            }
                            continue;
                        }
                        throw new HandlerException("Unknown entry point: " + sep + "; please check your rules source.");
                    }
                } else {
                    Object content = exchange.getMessage().getContent();
                    if (content != null) {
                        session.getStateful().insert(content);
                    }
                }
                if (!this.isDispose(exchange)) break;
                this.disposeStatefulSession();
                break;
            }
            default: {
                throw new HandlerException("Unsupported action type: " + (Object)((Object)actionType));
            }
        }
        Object output = Mappings.getOutput((Exchange)exchange, (KnowledgeAction)action);
        if (ExchangePattern.IN_OUT.equals((Object)exchange.getContract().getProviderOperation().getExchangePattern())) {
            Message message = exchange.createMessage().setContent(output);
            exchange.send(message);
        }
    }

    private boolean isDispose(Exchange exchange) {
        return this.isBoolean(exchange, RulesConstants.DISPOSE_PROPERTY, Scope.IN);
    }

    private final class FireUntilHalt
    implements Runnable,
    KnowledgeDisposal {
        private final RulesExchangeHandler _handler;
        private final KnowledgeSession _session;
        private final ClassLoader _loader;

        private FireUntilHalt(RulesExchangeHandler handler, KnowledgeSession session, ClassLoader loader) {
            this._handler = handler;
            this._session = session;
            this._loader = loader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader originalLoader = Classes.setTCCL((ClassLoader)this._loader);
            try {
                this._session.getStateful().fireUntilHalt();
            }
            finally {
                try {
                    this._handler.disposeStatefulSession();
                }
                finally {
                    Classes.setTCCL((ClassLoader)originalLoader);
                }
            }
        }

        public void dispose() {
            this._handler._fireUntilHaltThread = null;
        }

        private Thread startThread() {
            Thread thread = new Thread(this);
            String name = ((Object)((Object)this._handler)).getClass().getSimpleName() + ':' + this.getClass().getSimpleName() + ':' + FIRE_UNTIL_HALT_COUNT.incrementAndGet();
            thread.setName(name);
            thread.setDaemon(true);
            thread.start();
            return thread;
        }
    }
}

