/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.exchange;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.kie.api.runtime.rule.SessionEntryPoint;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.knowledge.OperationType;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeExchangeHandler;
import org.switchyard.component.common.knowledge.exchange.KnowledgeOperation;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.util.Operations;
import org.switchyard.component.rules.RulesConstants;
import org.switchyard.component.rules.RulesOperationType;
import org.switchyard.component.rules.config.model.RulesComponentImplementationModel;

public class RulesExchangeHandler
extends KnowledgeExchangeHandler<RulesComponentImplementationModel> {
    private static final AtomicInteger FIRE_UNTIL_HALT_COUNT = new AtomicInteger();
    private static final KnowledgeOperation DEFAULT_OPERATION = new KnowledgeOperation((OperationType)RulesOperationType.EXECUTE);
    private Thread _fireUntilHaltThread = null;

    public RulesExchangeHandler(RulesComponentImplementationModel model, ServiceDomain serviceDomain, QName serviceName) {
        super((KnowledgeComponentImplementationModel)model, serviceDomain, serviceName);
    }

    public KnowledgeOperation getDefaultOperation() {
        return DEFAULT_OPERATION;
    }

    public void handleOperation(Exchange exchange, KnowledgeOperation operation) throws HandlerException {
        Integer sessionId = null;
        Message inputMessage = exchange.getMessage();
        ExchangePattern exchangePattern = exchange.getContract().getProviderOperation().getExchangePattern();
        HashMap expressionContext = new HashMap();
        RulesOperationType operationType = (RulesOperationType)operation.getType();
        switch (operationType) {
            case EXECUTE: {
                KnowledgeSession session = this.newStatelessSession();
                sessionId = session.getId();
                Operations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeSession)session);
                List facts = Operations.getInputList((Message)inputMessage, (KnowledgeOperation)operation);
                session.getStateless().execute((Iterable)facts);
                if (!ExchangePattern.IN_OUT.equals((Object)exchangePattern)) break;
                expressionContext.putAll(this.getGlobalVariables(session));
                break;
            }
            case INSERT: 
            case FIRE_ALL_RULES: {
                KnowledgeSession session = this.getStatefulSession();
                sessionId = session.getId();
                Operations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeSession)session);
                List facts = Operations.getInputList((Message)inputMessage, (KnowledgeOperation)operation);
                for (Object fact : facts) {
                    session.getStateful().insert(fact);
                }
                if (RulesOperationType.FIRE_ALL_RULES.equals((Object)operationType)) {
                    session.getStateful().fireAllRules();
                }
                if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                    expressionContext.putAll(this.getGlobalVariables(session));
                }
                if (!this.isDispose(exchange, inputMessage)) break;
                this.disposeStatefulSession();
                break;
            }
            case FIRE_UNTIL_HALT: {
                KnowledgeSession session = this.getStatefulSession();
                sessionId = session.getId();
                Operations.setGlobals((Message)inputMessage, (KnowledgeOperation)operation, (KnowledgeSession)session);
                if (this._fireUntilHaltThread == null) {
                    FireUntilHalt fireUntilHalt = new FireUntilHalt(this, session, this.getLoader());
                    session.addDisposals(new KnowledgeDisposal[]{fireUntilHalt});
                    this._fireUntilHaltThread = fireUntilHalt.startThread();
                }
                String undefinedVariable = Operations.toVariable((Object)exchange);
                Map inputMap = Operations.getListMap((Message)inputMessage, (List)operation.getInputExpressionMappings(), (boolean)true, (String)undefinedVariable);
                if (inputMap.size() > 0) {
                    for (Map.Entry inputEntry : inputMap.entrySet()) {
                        String eventId;
                        String key = (String)inputEntry.getKey();
                        if (undefinedVariable.equals(key) && (eventId = Strings.trimToNull((String)operation.getEventId())) != null) {
                            key = eventId;
                        }
                        List facts = (List)inputEntry.getValue();
                        if (undefinedVariable.equals(key)) {
                            for (Object fact : facts) {
                                session.getStateful().insert(fact);
                            }
                            continue;
                        }
                        SessionEntryPoint sep = session.getStateful().getEntryPoint(key);
                        if (sep != null) {
                            for (Object fact : facts) {
                                sep.insert(fact);
                            }
                            continue;
                        }
                        throw new HandlerException("Unknown entry point: " + sep + "; please check your rules source.");
                    }
                } else {
                    List facts = Operations.getInputList((Message)inputMessage, (KnowledgeOperation)operation);
                    for (Object fact : facts) {
                        session.getStateful().insert(fact);
                    }
                }
                if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                    expressionContext.putAll(this.getGlobalVariables(session));
                }
                if (!this.isDispose(exchange, inputMessage)) break;
                this.disposeStatefulSession();
                break;
            }
            default: {
                throw new HandlerException("Unsupported operation type: " + (Object)((Object)operationType));
            }
        }
        if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
            Message outputMessage = exchange.createMessage();
            Context outputContext = exchange.getContext(outputMessage);
            if (sessionId != null && sessionId > 0) {
                outputContext.setProperty(RulesConstants.SESSION_ID_PROPERTY, (Object)sessionId);
            }
            Operations.setFaults((Message)outputMessage, (KnowledgeOperation)operation, expressionContext);
            if (outputMessage.getContent() != null) {
                exchange.sendFault(outputMessage);
            } else {
                Operations.setOutputs((Message)outputMessage, (KnowledgeOperation)operation, expressionContext);
                exchange.send(outputMessage);
            }
        }
    }

    private boolean isDispose(Exchange exchange, Message message) {
        return this.isBoolean(exchange, message, RulesConstants.DISPOSE_PROPERTY);
    }

    private final class FireUntilHalt
    implements Runnable,
    KnowledgeDisposal {
        private final RulesExchangeHandler _handler;
        private final KnowledgeSession _session;
        private final ClassLoader _loader;

        private FireUntilHalt(RulesExchangeHandler handler, KnowledgeSession session, ClassLoader loader) {
            this._handler = handler;
            this._session = session;
            this._loader = loader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader originalLoader = Classes.setTCCL((ClassLoader)this._loader);
            try {
                this._session.getStateful().fireUntilHalt();
            }
            finally {
                try {
                    this._handler.disposeStatefulSession();
                }
                finally {
                    Classes.setTCCL((ClassLoader)originalLoader);
                }
            }
        }

        public void dispose() {
            this._handler._fireUntilHaltThread = null;
        }

        private Thread startThread() {
            Thread thread = new Thread(this);
            String name = ((Object)((Object)this._handler)).getClass().getSimpleName() + ':' + this.getClass().getSimpleName() + ':' + FIRE_UNTIL_HALT_COUNT.incrementAndGet();
            thread.setName(name);
            thread.setDaemon(true);
            thread.start();
            return thread;
        }
    }
}

