/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.rules.config.model;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.classpath.ClasspathScanner;
import org.switchyard.common.type.classpath.Filter;
import org.switchyard.common.type.classpath.IsAnnotationPresentFilter;
import org.switchyard.component.common.knowledge.annotation.Fault;
import org.switchyard.component.common.knowledge.annotation.Global;
import org.switchyard.component.common.knowledge.annotation.Input;
import org.switchyard.component.common.knowledge.annotation.Output;
import org.switchyard.component.common.knowledge.config.model.KnowledgeSwitchYardScanner;
import org.switchyard.component.common.knowledge.config.model.OperationModel;
import org.switchyard.component.common.knowledge.config.model.OperationsModel;
import org.switchyard.component.common.knowledge.config.model.v1.V1OperationsModel;
import org.switchyard.component.rules.RulesMessages;
import org.switchyard.component.rules.RulesOperationType;
import org.switchyard.component.rules.annotation.Execute;
import org.switchyard.component.rules.annotation.FireAllRules;
import org.switchyard.component.rules.annotation.FireUntilHalt;
import org.switchyard.component.rules.annotation.Insert;
import org.switchyard.component.rules.annotation.Rules;
import org.switchyard.component.rules.config.model.RulesNamespace;
import org.switchyard.component.rules.config.model.v1.V1RulesComponentImplementationModel;
import org.switchyard.component.rules.config.model.v1.V1RulesOperationModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Namespace;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.composite.v1.V1ComponentModel;
import org.switchyard.config.model.composite.v1.V1ComponentServiceModel;
import org.switchyard.config.model.composite.v1.V1CompositeModel;
import org.switchyard.config.model.composite.v1.V1InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.switchyard.SwitchYardNamespace;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;
import org.switchyard.extensions.java.JavaService;
import org.switchyard.metadata.ServiceOperation;

public class RulesSwitchYardScanner
extends KnowledgeSwitchYardScanner {
    private static final IsAnnotationPresentFilter EXECUTE_FILTER = new IsAnnotationPresentFilter(Execute.class);
    private static final IsAnnotationPresentFilter INSERT_FILTER = new IsAnnotationPresentFilter(Insert.class);
    private static final IsAnnotationPresentFilter FIRE_ALL_RULES_FILTER = new IsAnnotationPresentFilter(FireAllRules.class);
    private static final IsAnnotationPresentFilter FIRE_UNTIL_HALT_FILTER = new IsAnnotationPresentFilter(FireUntilHalt.class);
    private final IsAnnotationPresentFilter _rulesFilter = new IsAnnotationPresentFilter(Rules.class);

    public ScannerOutput<SwitchYardModel> scan(ScannerInput<SwitchYardModel> input) throws IOException {
        SwitchYardNamespace switchyardNamespace = input.getSwitchyardNamespace();
        V1SwitchYardModel switchyardModel = new V1SwitchYardModel(switchyardNamespace.uri());
        V1CompositeModel compositeModel = new V1CompositeModel();
        compositeModel.setName(input.getCompositeName());
        ClasspathScanner rulesScanner = new ClasspathScanner((Filter)this._rulesFilter);
        for (URL url : input.getURLs()) {
            rulesScanner.scan(url);
        }
        List rulesClasses = this._rulesFilter.getMatchedTypes();
        for (Class rulesClass : rulesClasses) {
            compositeModel.addComponent(this.scan(rulesClass, switchyardNamespace));
        }
        if (!compositeModel.getModelChildren().isEmpty()) {
            switchyardModel.setComposite((CompositeModel)compositeModel);
        }
        return new ScannerOutput().setModel((Model)switchyardModel);
    }

    public ComponentModel scan(Class<?> rulesClass) throws IOException {
        return this.scan(rulesClass, null);
    }

    public ComponentModel scan(Class<?> rulesClass, SwitchYardNamespace switchyardNamespace) throws IOException {
        Rules rules;
        Class<?> rulesInterface;
        if (switchyardNamespace == null) {
            switchyardNamespace = SwitchYardNamespace.DEFAULT;
        }
        if (Rules.UndefinedRulesInterface.class.equals(rulesInterface = (rules = rulesClass.getAnnotation(Rules.class)).value())) {
            rulesInterface = rulesClass;
        }
        if (!rulesInterface.isInterface()) {
            throw RulesMessages.MESSAGES.rulesInterfaceGetNameIsAClassRulesOnlyAllowedOnInterfaces(rulesInterface.getName());
        }
        String rulesName = Strings.trimToNull((String)rules.name());
        if (rulesName == null) {
            rulesName = rulesInterface.getSimpleName();
        }
        V1ComponentModel componentModel = new V1ComponentModel();
        componentModel.setName(rulesName);
        RulesNamespace rulesNamespace = RulesNamespace.fromUri(rules.namespace());
        if (rulesNamespace == null) {
            rulesNamespace = RulesNamespace.DEFAULT;
            for (RulesNamespace value : RulesNamespace.values()) {
                if (!value.versionMatches((Namespace)switchyardNamespace)) continue;
                rulesNamespace = value;
                break;
            }
        }
        V1RulesComponentImplementationModel componentImplementationModel = new V1RulesComponentImplementationModel(rulesNamespace.uri());
        V1OperationsModel operationsModel = new V1OperationsModel(rulesNamespace.uri());
        JavaService javaService = JavaService.fromClass(rulesInterface);
        for (Method method : rulesClass.getDeclaredMethods()) {
            ServiceOperation serviceOperation;
            RulesOperationType operationType = null;
            String eventId = null;
            Global[] globalMappingAnnotations = null;
            Input[] inputMappingAnnotations = null;
            Output[] outputMappingAnnotations = null;
            Fault[] faultMappingAnnotations = null;
            if (EXECUTE_FILTER.matches(method)) {
                operationType = RulesOperationType.EXECUTE;
                Execute executeAnnotation = method.getAnnotation(Execute.class);
                globalMappingAnnotations = executeAnnotation.globals();
                inputMappingAnnotations = executeAnnotation.inputs();
                outputMappingAnnotations = executeAnnotation.outputs();
                faultMappingAnnotations = executeAnnotation.faults();
            } else if (INSERT_FILTER.matches(method)) {
                operationType = RulesOperationType.INSERT;
                Insert insertAnnotation = method.getAnnotation(Insert.class);
                globalMappingAnnotations = insertAnnotation.globals();
                inputMappingAnnotations = insertAnnotation.inputs();
                outputMappingAnnotations = insertAnnotation.outputs();
                faultMappingAnnotations = insertAnnotation.faults();
            } else if (FIRE_ALL_RULES_FILTER.matches(method)) {
                operationType = RulesOperationType.FIRE_ALL_RULES;
                FireAllRules fireAllRulesAnnotation = method.getAnnotation(FireAllRules.class);
                globalMappingAnnotations = fireAllRulesAnnotation.globals();
                inputMappingAnnotations = fireAllRulesAnnotation.inputs();
                outputMappingAnnotations = fireAllRulesAnnotation.outputs();
                faultMappingAnnotations = fireAllRulesAnnotation.faults();
            } else if (FIRE_UNTIL_HALT_FILTER.matches(method)) {
                operationType = RulesOperationType.FIRE_UNTIL_HALT;
                FireUntilHalt fireUntilHaltAnnotation = method.getAnnotation(FireUntilHalt.class);
                eventId = Strings.trimToNull((String)fireUntilHaltAnnotation.eventId());
                globalMappingAnnotations = fireUntilHaltAnnotation.globals();
                inputMappingAnnotations = fireUntilHaltAnnotation.inputs();
                outputMappingAnnotations = fireUntilHaltAnnotation.outputs();
                faultMappingAnnotations = fireUntilHaltAnnotation.faults();
            }
            if (operationType == null || (serviceOperation = javaService.getOperation(method.getName())) == null) continue;
            V1RulesOperationModel operationModel = new V1RulesOperationModel(rulesNamespace.uri());
            operationModel.setEventId(eventId);
            operationModel.setName(serviceOperation.getName());
            operationModel.setType(operationType);
            operationModel.setGlobals(this.toGlobalsModel(globalMappingAnnotations, rulesNamespace));
            operationModel.setInputs(this.toInputsModel(inputMappingAnnotations, rulesNamespace));
            operationModel.setOutputs(this.toOutputsModel(outputMappingAnnotations, rulesNamespace));
            operationModel.setFaults(this.toFaultsModel(faultMappingAnnotations, rulesNamespace));
            operationsModel.addOperation((OperationModel)operationModel);
        }
        if (!operationsModel.getOperations().isEmpty()) {
            componentImplementationModel.setOperations((OperationsModel)operationsModel);
        }
        componentImplementationModel.setChannels(this.toChannelsModel(rules.channels(), rulesNamespace, (ComponentModel)componentModel, switchyardNamespace));
        componentImplementationModel.setListeners(this.toListenersModel(rules.listeners(), rulesNamespace));
        componentImplementationModel.setLoggers(this.toLoggersModel(rules.loggers(), rulesNamespace));
        componentImplementationModel.setManifest(this.toManifestModel(rules.manifest(), rulesNamespace));
        componentImplementationModel.setProperties(this.toPropertiesModel(rules.properties(), rulesNamespace));
        componentModel.setImplementation((ComponentImplementationModel)componentImplementationModel);
        V1ComponentServiceModel componentServiceModel = new V1ComponentServiceModel(switchyardNamespace.uri());
        V1InterfaceModel interfaceModel = new V1InterfaceModel("java");
        interfaceModel.setInterface(rulesInterface.getName());
        componentServiceModel.setInterface((InterfaceModel)interfaceModel);
        componentServiceModel.setName(rulesName);
        componentModel.addService((ComponentServiceModel)componentServiceModel);
        return componentModel;
    }
}

