/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.config.model.composite.SCABindingModel;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.RemoteRegistry;
import org.switchyard.remote.cluster.ClusteredInvoker;
import org.switchyard.remote.cluster.LoadBalanceStrategy;
import org.switchyard.remote.cluster.RandomStrategy;
import org.switchyard.remote.cluster.RoundRobinStrategy;

public class SCAInvoker
extends BaseServiceHandler {
    private SCABindingModel _config;
    private ClusteredInvoker _invoker;

    public SCAInvoker(SCABindingModel config) {
        this._config = config;
    }

    public SCAInvoker(SCABindingModel config, RemoteRegistry registry) {
        this._config = config;
        if (config.isLoadBalanced()) {
            LoadBalanceStrategy loadBalancer = this.createLoadBalancer(config.getLoadBalance());
            this._invoker = new ClusteredInvoker(registry, loadBalancer);
        } else {
            this._invoker = new ClusteredInvoker(registry);
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        try {
            if (this._config.isClustered()) {
                this.invokeRemote(exchange);
            } else {
                this.invokeLocal(exchange);
            }
        }
        catch (SwitchYardException syEx) {
            throw new HandlerException(syEx.getMessage());
        }
    }

    private void invokeLocal(Exchange exchange) {
        QName serviceName = this.getTargetServiceName(exchange);
        ServiceReference ref = exchange.getProvider().getDomain().getServiceReference(serviceName);
        SynchronousInOutHandler replyHandler = new SynchronousInOutHandler();
        Exchange ex = ref.createExchange(exchange.getContract().getProviderOperation().getName(), (ExchangeHandler)replyHandler);
        ex.send(exchange.getMessage());
        if (this.isInOut(ex)) {
            replyHandler.waitForOut();
            Message msg = ex.getMessage();
            if (ExchangeState.FAULT.equals((Object)ex.getState())) {
                exchange.sendFault(msg);
            } else {
                exchange.send(msg);
            }
        }
    }

    private void invokeRemote(Exchange exchange) {
        QName serviceName = this.getTargetServiceName(exchange);
        RemoteMessage request = new RemoteMessage().setDomain(exchange.getProvider().getDomain().getName()).setService(serviceName).setContent(exchange.getMessage().getContent()).setContext(exchange.getContext());
        try {
            RemoteMessage reply = this._invoker.invoke(request);
            if (this.isInOut(exchange) && reply != null) {
                Message msg = exchange.getMessage().setContent(reply.getContent());
                if (reply.isFault()) {
                    exchange.sendFault(msg);
                } else {
                    exchange.send(msg);
                }
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            exchange.sendFault(exchange.createMessage().setContent((Object)ioEx));
        }
    }

    private QName getTargetServiceName(Exchange exchange) {
        QName service = exchange.getProvider().getName();
        String targetName = this._config.hasTarget() ? this._config.getTarget() : service.getLocalPart();
        String targetNS = this._config.hasTargetNamespace() ? this._config.getTargetNamespace() : service.getNamespaceURI();
        return new QName(targetNS, targetName);
    }

    LoadBalanceStrategy createLoadBalancer(String strategy) {
        if (RoundRobinStrategy.class.getSimpleName().equals(strategy)) {
            return new RoundRobinStrategy();
        }
        if (RandomStrategy.class.getSimpleName().equals(strategy)) {
            return new RandomStrategy();
        }
        try {
            Class<?> strategyClass = Class.forName(strategy);
            if (!LoadBalanceStrategy.class.isAssignableFrom(strategyClass)) {
                throw new SwitchYardException("Load balance class does not implement LoadBalanceStrategy: " + strategy);
            }
            return (LoadBalanceStrategy)strategyClass.newInstance();
        }
        catch (Exception ex) {
            throw new SwitchYardException("Unable to instantiate strategy class: " + strategy, (Throwable)ex);
        }
    }

    private boolean isInOut(Exchange exchange) {
        return ExchangePattern.IN_OUT.equals((Object)exchange.getContract().getConsumerOperation().getExchangePattern());
    }
}

