/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.common.type.Classes;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;
import org.switchyard.transform.TransformSequence;

public class SwitchYardRemotingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger _log = Logger.getLogger(SwitchYardRemotingServlet.class);
    private Serializer _serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);
    private RemoteEndpointPublisher _endpointPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClassLoader setTCCL = null;
        try {
            ServiceDomain domain = this.findDomain(request);
            ClassLoader loader = (ClassLoader)domain.getProperties().get("DeploymentClassloader");
            setTCCL = Classes.setTCCL((ClassLoader)loader);
            RemoteMessage msg = (RemoteMessage)this._serializer.deserialize((InputStream)request.getInputStream(), RemoteMessage.class);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Remote servlet received request for service " + msg.getService()));
            }
            ServiceReference service = domain.getServiceReference(msg.getService());
            SynchronousInOutHandler replyHandler = new SynchronousInOutHandler();
            Exchange ex = msg.getOperation() == null ? service.createExchange((ExchangeHandler)replyHandler) : service.createExchange(msg.getOperation(), (ExchangeHandler)replyHandler);
            Message m = ex.createMessage();
            if (msg.getContext() != null) {
                ex.getContext().setProperties(msg.getContext().getProperties());
            }
            m.setContent(msg.getContent());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invoking service " + msg.getService()));
            }
            ex.send(m);
            if (ex.getContract().getProviderOperation().getExchangePattern().equals((Object)ExchangePattern.IN_OUT)) {
                replyHandler.waitForOut();
                RemoteMessage reply = this.createReplyMessage(ex);
                ServletOutputStream out = response.getOutputStream();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Writing reply message to HTTP response stream " + msg.getService()));
                }
                this._serializer.serialize((Object)reply, RemoteMessage.class, (OutputStream)out);
                out.flush();
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No content to return for invocation of " + msg.getService()));
                }
                response.setStatus(204);
            }
            if (setTCCL == null) return;
        }
        catch (SwitchYardException syEx) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Failed to process remote invocation", (Throwable)syEx);
                }
                RemoteMessage reply = new RemoteMessage();
                reply.setFault(true);
                reply.setContent((Object)syEx);
                this._serializer.serialize((Object)reply, RemoteMessage.class, (OutputStream)response.getOutputStream());
                response.getOutputStream().flush();
                if (setTCCL == null) return;
            }
            catch (Throwable throwable) {
                if (setTCCL == null) throw throwable;
                Classes.setTCCL(setTCCL);
                throw throwable;
            }
            Classes.setTCCL((ClassLoader)setTCCL);
            return;
        }
        Classes.setTCCL((ClassLoader)setTCCL);
        return;
    }

    private ServiceDomain findDomain(HttpServletRequest request) throws SwitchYardException {
        ServiceDomain domain = null;
        String service = request.getHeader("switchyard-service");
        if (service == null || service.trim().length() == 0) {
            throw new SwitchYardException("Required 'switchyard-service' header is missing or empty");
        }
        domain = this._endpointPublisher.getDomain(QName.valueOf(service));
        if (domain == null) {
            throw new SwitchYardException("Unable to find ServiceDomain for service: " + service + ". Verify the service name and namespace are registered in the runtime.");
        }
        return domain;
    }

    public void setEndpointPublisher(RemoteEndpointPublisher endpointPublisher) {
        this._endpointPublisher = endpointPublisher;
    }

    RemoteMessage createReplyMessage(Exchange exchange) {
        RemoteMessage reply = new RemoteMessage();
        this.cleanContext(exchange);
        reply.setContext(exchange.getContext()).setDomain(exchange.getProvider().getDomain().getName()).setOperation(exchange.getContract().getConsumerOperation().getName()).setService(exchange.getConsumer().getName());
        if (exchange.getMessage() != null) {
            reply.setContent(exchange.getMessage().getContent());
        }
        if (exchange.getState().equals((Object)ExchangeState.FAULT)) {
            reply.setFault(true);
        }
        return reply;
    }

    private void cleanContext(Exchange exchange) {
        Property inTransform = exchange.getContext().getProperty(TransformSequence.class.getName(), Scope.IN);
        Property outTransform = exchange.getContext().getProperty(TransformSequence.class.getName(), Scope.OUT);
        if (inTransform != null) {
            exchange.getContext().removeProperty(inTransform);
        }
        if (outTransform != null) {
            exchange.getContext().removeProperty(outTransform);
        }
    }
}

