/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca.deploy;

import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.component.sca.deploy.SCAActivator;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.BaseComponent;

public class SCAComponent
extends BaseComponent {
    private static final String CONTEXT_PATH = "switchyard-remote";
    private static Logger _log = Logger.getLogger(SCAComponent.class);
    private RemoteEndpointPublisher _endpointPublisher;

    public SCAComponent() {
        super(SCAActivator.TYPES);
        this.setName("RemoteComponent");
        try {
            this._endpointPublisher = ServiceLoader.load(RemoteEndpointPublisher.class).iterator().next();
            this._endpointPublisher.init(CONTEXT_PATH);
        }
        catch (Exception ex) {
            _log.warn((Object)"Failed to initialize remote endpoint publisher", (Throwable)ex);
        }
    }

    public Activator createActivator(ServiceDomain domain) {
        SCAActivator activator = new SCAActivator(this.getConfig());
        activator.setServiceDomain(domain);
        activator.setEndpointPublisher(this._endpointPublisher);
        return activator;
    }

    public synchronized void destroy() {
        try {
            this._endpointPublisher.stop();
        }
        catch (Exception ex) {
            _log.warn((Object)"Failed to destroy remote endpoint publisher", (Throwable)ex);
        }
    }
}

