/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.infinispan.Cache;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.component.sca.SCAEndpoint;
import org.switchyard.component.sca.SCAInvoker;
import org.switchyard.component.sca.SCALogger;
import org.switchyard.component.sca.SCAMessages;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.SCABindingModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.remote.RemoteRegistry;
import org.switchyard.remote.infinispan.InfinispanRegistry;

public class SCAActivator
extends BaseActivator {
    private static final String CACHE_CONTAINER_ROOT = "java:jboss/infinispan/container/";
    private static final String CACHE_NAME_PROPERTY = "cache-name";
    private static final String CACHE_CONFIG_PROPERTY = "cache-config";
    private static final String DISABLE_REMOTE_TRANSACTION_PROPERTY = "disable-remote-transaction";
    private static final String JGROUPS_CONFIG_PROPERTY = "jgroups-config";
    static final String[] TYPES = new String[]{"sca"};
    private static Logger _log = Logger.getLogger(SCAActivator.class);
    private Cache<String, String> _cache;
    private RemoteRegistry _registry;
    private RemoteEndpointPublisher _endpointPublisher;
    private boolean _disableRemoteTransaction = false;

    public SCAActivator(Configuration environment) {
        super(TYPES);
        Configuration cacheFileConfig;
        String cacheName = "cluster";
        Configuration cacheNameConfig = environment.getFirstChild(CACHE_NAME_PROPERTY);
        if (cacheNameConfig != null) {
            cacheName = cacheNameConfig.getValue();
        }
        if ((cacheFileConfig = environment.getFirstChild(CACHE_CONFIG_PROPERTY)) != null && cacheFileConfig.getValue() != null) {
            Configuration jgroupsConfig = environment.getFirstChild(JGROUPS_CONFIG_PROPERTY);
            this.createCache(cacheFileConfig.getValue(), cacheName, jgroupsConfig != null ? jgroupsConfig.getValue() : null);
        } else {
            this.lookupCache(cacheName);
        }
        if (this._cache != null) {
            this._registry = new InfinispanRegistry(this._cache);
        } else {
            SCALogger.ROOT_LOGGER.unableToResolveCacheContainer(cacheName);
        }
        Configuration bridgeRemoteTxConfig = environment.getFirstChild(DISABLE_REMOTE_TRANSACTION_PROPERTY);
        if (bridgeRemoteTxConfig != null) {
            this._disableRemoteTransaction = Boolean.parseBoolean(bridgeRemoteTxConfig.getValue());
        }
    }

    public ServiceHandler activateBinding(QName name, BindingModel config) {
        this._endpointPublisher.setDisableRemoteTransaction(this._disableRemoteTransaction);
        try {
            this._endpointPublisher.start();
        }
        catch (Exception ex) {
            SCALogger.ROOT_LOGGER.failedToStartRemoteEndpointListenerForSCAEndpoints(ex);
        }
        SCABindingModel scab = (SCABindingModel)config;
        if (scab.isServiceBinding()) {
            return new SCAEndpoint(scab, super.getServiceDomain(), this._endpointPublisher, this._registry);
        }
        if (scab.getTarget() == null && scab.getTargetNamespace() == null) {
            throw SCAMessages.MESSAGES.invalidSCABindingForReferenceTargetServiceOrNamespaceMustBeSpecified();
        }
        return new SCAInvoker(scab, this._registry).setDisableRemoteTransaction(this._disableRemoteTransaction);
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    public void setEndpointPublisher(RemoteEndpointPublisher endpointPublisher) {
        this._endpointPublisher = endpointPublisher;
    }

    public RemoteEndpointPublisher getEndpointPublisher() {
        return this._endpointPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCache(String cacheConfig, String cacheName, String jgroupsConfig) {
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        try {
            InputStream configStream = null;
            try {
                File f = new File(cacheConfig);
                configStream = f.exists() && f.isFile() ? new FileInputStream(f) : SCAActivator.class.getClassLoader().getResourceAsStream(cacheConfig);
                ClassLoader cacheClassLoader = DefaultCacheManager.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(cacheClassLoader);
                ConfigurationBuilderHolder holder = new ParserRegistry(cacheClassLoader).parse(configStream);
                if (jgroupsConfig != null) {
                    holder.getGlobalConfigurationBuilder().transport().defaultTransport().addProperty("configurationFile", jgroupsConfig);
                }
                this._cache = new DefaultCacheManager(holder, true).getCache(cacheName);
            }
            finally {
                if (configStream != null) {
                    try {
                        configStream.close();
                    }
                    catch (Exception e) {
                        e.fillInStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            _log.debug((Object)"Failed to create cache for distributed registry", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }

    private void lookupCache(String cacheName) {
        try {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)new InitialContext().lookup(CACHE_CONTAINER_ROOT + cacheName);
            this._cache = cm.getCache();
        }
        catch (Exception ex) {
            _log.debug((Object)"Failed to lookup cache container for distributed registry", (Throwable)ex);
        }
    }
}

