/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca.deploy;

import org.switchyard.ServiceDomain;
import org.switchyard.common.util.ProviderRegistry;
import org.switchyard.component.sca.NOPEndpointPublisher;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.component.sca.SCALogger;
import org.switchyard.component.sca.deploy.SCAActivator;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.BaseComponent;

public class SCAComponent
extends BaseComponent {
    private static final String CONTEXT_PATH = "switchyard-remote";
    private RemoteEndpointPublisher _endpointPublisher;

    public SCAComponent() {
        super(SCAActivator.TYPES);
        this.setName("RemoteComponent");
        try {
            this.initEndpointPublisher();
        }
        catch (Exception ex) {
            SCALogger.ROOT_LOGGER.failedToInitializeRemoteEndpointPublisher(ex);
        }
    }

    public Activator createActivator(ServiceDomain domain) {
        SCAActivator activator = new SCAActivator(this.getConfig());
        activator.setServiceDomain(domain);
        activator.setEndpointPublisher(this._endpointPublisher);
        return activator;
    }

    public synchronized void destroy() {
        try {
            this._endpointPublisher.stop();
        }
        catch (Exception ex) {
            SCALogger.ROOT_LOGGER.failedToDestroyRemoteEndpointPublisher(ex);
        }
    }

    private void initEndpointPublisher() {
        this._endpointPublisher = (RemoteEndpointPublisher)ProviderRegistry.getProvider(RemoteEndpointPublisher.class);
        if (this._endpointPublisher == null) {
            this._endpointPublisher = new NOPEndpointPublisher();
            SCALogger.ROOT_LOGGER.noEndpointPublisherRegistered();
        }
        this._endpointPublisher.init(CONTEXT_PATH);
    }
}

