/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.switchyard.HandlerException;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.transform.BaseTransformer;

public class HandlerExceptionTransformer<F extends HandlerException, T extends SOAPMessage>
extends BaseTransformer<F, T> {
    public QName getFrom() {
        return new QName("java:org.switchyard.HandlerException");
    }

    public QName getTo() {
        return WSDLUtil.SOAP_FAULT_MESSAGE_TYPE;
    }

    public SOAPMessage transform(HandlerException from) {
        try {
            Throwable cause = from.getCause();
            if (cause instanceof InvocationTargetException) {
                return SOAPUtil.generateFault(cause.getCause());
            }
            return SOAPUtil.generateFault((Throwable)from);
        }
        catch (SOAPException e1) {
            throw new IllegalStateException("Unexpected SOAPException when generating a SOAP Fault message.", (Throwable)from);
        }
    }
}

