/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.deploy;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.deploy.Activator;

public class SOAPActivator
implements Activator {
    private Map<QName, InboundHandler> _inboundGateways = new HashMap<QName, InboundHandler>();

    public ExchangeHandler init(QName name, Model config) {
        if (config instanceof CompositeServiceModel) {
            for (BindingModel binding : ((CompositeServiceModel)config).getBindings()) {
                if (!(binding instanceof SOAPBindingModel)) continue;
                InboundHandler handler = new InboundHandler((SOAPBindingModel)binding);
                this._inboundGateways.put(name, handler);
                return handler;
            }
        }
        throw new RuntimeException("No SOAP bindings found for service " + name);
    }

    public void start(ServiceReference service) {
        if (this._inboundGateways.containsKey(service.getName())) {
            try {
                this._inboundGateways.get(service.getName()).start(service);
            }
            catch (WebServicePublishException ex) {
                throw new RuntimeException("Failed to start inbound gateway for service " + service.getName(), ex);
            }
        }
    }

    public void stop(ServiceReference service) {
        if (this._inboundGateways.containsKey(service.getName())) {
            this._inboundGateways.get(service.getName()).stop();
        }
    }

    public void destroy(ServiceReference service) {
        this._inboundGateways.remove(service.getName());
    }
}

