/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.switchyard.Message;
import org.switchyard.component.soap.MessageDecomposer;
import org.switchyard.component.soap.util.SOAPUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultMessageDecomposer
implements MessageDecomposer {
    @Override
    public SOAPMessage decompose(Message message) throws SOAPException {
        if (SOAPUtil.SOAP_MESSAGE_FACTORY == null) {
            throw new SOAPException("Failed to instantiate SOAP Message Factory");
        }
        SOAPMessage response = SOAPUtil.SOAP_MESSAGE_FACTORY.createMessage();
        if (message != null) {
            Object messagePayload = message.getContent();
            if (messagePayload instanceof SOAPMessage) {
                return (SOAPMessage)messagePayload;
            }
            Element input = this.toElement(messagePayload);
            if (input == null) {
                throw new SOAPException("Null response from service");
            }
            try {
                Node node = response.getSOAPBody().getOwnerDocument().importNode(input, true);
                response.getSOAPBody().appendChild(node);
            }
            catch (Exception e) {
                throw new SOAPException("Unable to parse SOAP Message", (Throwable)e);
            }
        }
        return response;
    }

    private Element toElement(Object messagePayload) throws SOAPException {
        if (messagePayload == null) {
            return null;
        }
        if (messagePayload instanceof Element) {
            return (Element)messagePayload;
        }
        if (messagePayload instanceof String) {
            try {
                return SOAPUtil.parseAsDom((String)messagePayload).getDocumentElement();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SOAPException("Error parsing SOAP message to DOM Element.", (Throwable)e);
            }
        }
        throw new SOAPException("Unsupported SOAP message payload type '" + messagePayload.getClass().getName() + "'.  Must be a DOM Element, or a String.");
    }
}

